/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.monitoring.models;

import io.inugami.api.monitoring.models.IHeaders;
import io.inugami.api.processors.ConfigHandler;
import io.inugami.api.processors.DefaultConfigHandler;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class Headers
implements IHeaders {
    public static final String X_DEVICE_IDENTIFIER = "x-device-identifier";
    public static final String X_CORRELATION_ID = "x-correlation-id";
    public static final String X_CONVERSATION_ID = "x-conversation-id";
    public static final String X_B_3_TRACEID = "x-b3-traceid";
    public static final String AUTHORIZATION = "Authorization";
    public static final String X_DEVICE_TYPE = "x-device-type";
    public static final String X_DEVICE_CLASS = "x-device-class";
    public static final String X_DEVICE_SYSTEM = "x-device-system";
    public static final String X_DEVICE_VERSION = "x-device-version";
    public static final String X_DEVICE_OS_VERSION = "x-device-os-version";
    public static final String X_DEVICE_NETWORK_TYPE = "x-device-network-type";
    public static final String X_DEVICE_NETWORK_SPEED_DOWN = "x-device-network-speed-down";
    public static final String X_DEVICE_NETWORK_SPEED_UP = "x-device-network-speed-up";
    public static final String X_DEVICE_NETWORK_SPEED_LATENCY = "x-device-network-speed-latency";
    public static final String CLIENT_IP = "clientIp";
    public static final String USER_AGENT = "User-Agent";
    public static final String ACCEPT_LANGUAGE = "Accept-Language";
    public static final String COUNTRY = "country";
    public static final String WARNING = "Warning";
    public static final String ERROR_CODE = "errorCode";
    public static final String ERROR_EXCEPTION = "errorException";
    public static final String ERROR_MESSAGE = "errorMessage";
    public static final String ERROR_MESSAGE_DETAIL = "errorMessageDetail";
    public static final String X_FRONT_VERSION = "x-front-version";
    public static final String X_APPLICATION = "x-application";
    private String correlationId;
    private String requestId;
    private String traceId;
    private String conversationId;
    private String token;
    private String deviceIdentifier;
    private String deviceType;
    private String deviceSystem;
    private String deviceClass;
    private String deviceVersion;
    private String deviceOsVersion;
    private String deviceNetworkType;
    private String deviceNetworkSpeedDown;
    private String deviceNetworkSpeedUp;
    private String deviceNetworkSpeedLatency;
    private String deviceIp;
    private String userAgent;
    private String language;
    private String country;
    private String warning;
    private String errorCode;
    private String errorException;
    private String errorMessage;
    private String errorMessageDetail;
    private String frontVersion;
    private String callFrom;
    private Set<String> specificHeaders = new LinkedHashSet<String>();

    public static Headers buildFromConfig(ConfigHandler<String, String> configuration) {
        Headers result = new Headers();
        result.refreshConfig(configuration);
        return result;
    }

    public Headers refreshConfig() {
        return this.refreshConfig(new DefaultConfigHandler());
    }

    public Headers refreshConfig(ConfigHandler<String, String> configuration) {
        this.correlationId = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.correlationId", (Object)X_CORRELATION_ID);
        this.requestId = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.requestId", (Object)X_B_3_TRACEID);
        this.traceId = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.traceId", (Object)X_B_3_TRACEID);
        this.conversationId = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.conversationId", (Object)X_CONVERSATION_ID);
        this.token = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.token", (Object)AUTHORIZATION);
        this.deviceIdentifier = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceIdentifier", (Object)X_DEVICE_IDENTIFIER);
        this.deviceType = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceType", (Object)X_DEVICE_TYPE);
        this.deviceClass = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceClass", (Object)X_DEVICE_CLASS);
        this.deviceSystem = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceSystem", (Object)X_DEVICE_SYSTEM);
        this.deviceVersion = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceVersion", (Object)X_DEVICE_VERSION);
        this.deviceOsVersion = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceOsVersion", (Object)X_DEVICE_OS_VERSION);
        this.deviceNetworkType = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceNetworkType", (Object)X_DEVICE_NETWORK_TYPE);
        this.deviceNetworkSpeedDown = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceNetworkSpeedDown", (Object)X_DEVICE_NETWORK_SPEED_DOWN);
        this.deviceNetworkSpeedUp = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceNetworkSpeedUp", (Object)X_DEVICE_NETWORK_SPEED_UP);
        this.deviceNetworkSpeedLatency = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceNetworkSpeedLatency", (Object)X_DEVICE_NETWORK_SPEED_LATENCY);
        this.deviceIp = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.deviceIp", (Object)CLIENT_IP);
        this.userAgent = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.userAgent", (Object)USER_AGENT);
        this.language = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.language", (Object)ACCEPT_LANGUAGE);
        this.country = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.country", (Object)COUNTRY);
        this.warning = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.warning", (Object)WARNING);
        this.errorCode = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.error.code", (Object)ERROR_CODE);
        this.errorException = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.error.exception", (Object)ERROR_EXCEPTION);
        this.errorMessage = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.error.message", (Object)ERROR_MESSAGE);
        this.errorMessageDetail = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.error.message.detail", (Object)ERROR_MESSAGE_DETAIL);
        this.frontVersion = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.front.version", (Object)X_FRONT_VERSION);
        this.callFrom = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.front.application", (Object)X_APPLICATION);
        String specifics = (String)configuration.getOrDefault((Object)"inugami.monitoring.headers.specifics", (Object)"");
        if (specifics != null && !specifics.isEmpty()) {
            this.specificHeaders.addAll(Arrays.asList(specifics.split(",")).stream().map(String::trim).collect(Collectors.toList()));
        }
        return this;
    }

    public static HeadersBuilder builder() {
        return new HeadersBuilder();
    }

    public HeadersBuilder toBuilder() {
        return new HeadersBuilder().correlationId(this.correlationId).requestId(this.requestId).traceId(this.traceId).conversationId(this.conversationId).token(this.token).deviceIdentifier(this.deviceIdentifier).deviceType(this.deviceType).deviceSystem(this.deviceSystem).deviceClass(this.deviceClass).deviceVersion(this.deviceVersion).deviceOsVersion(this.deviceOsVersion).deviceNetworkType(this.deviceNetworkType).deviceNetworkSpeedDown(this.deviceNetworkSpeedDown).deviceNetworkSpeedUp(this.deviceNetworkSpeedUp).deviceNetworkSpeedLatency(this.deviceNetworkSpeedLatency).deviceIp(this.deviceIp).userAgent(this.userAgent).language(this.language).country(this.country).warning(this.warning).errorCode(this.errorCode).errorException(this.errorException).errorMessage(this.errorMessage).errorMessageDetail(this.errorMessageDetail).frontVersion(this.frontVersion).callFrom(this.callFrom).specificHeaders(this.specificHeaders);
    }

    public String toString() {
        return "Headers(correlationId=" + this.getCorrelationId() + ", requestId=" + this.getRequestId() + ", traceId=" + this.getTraceId() + ", conversationId=" + this.getConversationId() + ", token=" + this.getToken() + ", deviceIdentifier=" + this.getDeviceIdentifier() + ", deviceType=" + this.getDeviceType() + ", deviceSystem=" + this.getDeviceSystem() + ", deviceClass=" + this.getDeviceClass() + ", deviceVersion=" + this.getDeviceVersion() + ", deviceOsVersion=" + this.getDeviceOsVersion() + ", deviceNetworkType=" + this.getDeviceNetworkType() + ", deviceNetworkSpeedDown=" + this.getDeviceNetworkSpeedDown() + ", deviceNetworkSpeedUp=" + this.getDeviceNetworkSpeedUp() + ", deviceNetworkSpeedLatency=" + this.getDeviceNetworkSpeedLatency() + ", deviceIp=" + this.getDeviceIp() + ", userAgent=" + this.getUserAgent() + ", language=" + this.getLanguage() + ", country=" + this.getCountry() + ", warning=" + this.getWarning() + ", errorCode=" + this.getErrorCode() + ", errorException=" + this.getErrorException() + ", errorMessage=" + this.getErrorMessage() + ", errorMessageDetail=" + this.getErrorMessageDetail() + ", frontVersion=" + this.getFrontVersion() + ", callFrom=" + this.getCallFrom() + ", specificHeaders=" + this.getSpecificHeaders() + ")";
    }

    public Headers() {
    }

    public Headers(String correlationId, String requestId, String traceId, String conversationId, String token, String deviceIdentifier, String deviceType, String deviceSystem, String deviceClass, String deviceVersion, String deviceOsVersion, String deviceNetworkType, String deviceNetworkSpeedDown, String deviceNetworkSpeedUp, String deviceNetworkSpeedLatency, String deviceIp, String userAgent, String language, String country, String warning, String errorCode, String errorException, String errorMessage, String errorMessageDetail, String frontVersion, String callFrom, Set<String> specificHeaders) {
        this.correlationId = correlationId;
        this.requestId = requestId;
        this.traceId = traceId;
        this.conversationId = conversationId;
        this.token = token;
        this.deviceIdentifier = deviceIdentifier;
        this.deviceType = deviceType;
        this.deviceSystem = deviceSystem;
        this.deviceClass = deviceClass;
        this.deviceVersion = deviceVersion;
        this.deviceOsVersion = deviceOsVersion;
        this.deviceNetworkType = deviceNetworkType;
        this.deviceNetworkSpeedDown = deviceNetworkSpeedDown;
        this.deviceNetworkSpeedUp = deviceNetworkSpeedUp;
        this.deviceNetworkSpeedLatency = deviceNetworkSpeedLatency;
        this.deviceIp = deviceIp;
        this.userAgent = userAgent;
        this.language = language;
        this.country = country;
        this.warning = warning;
        this.errorCode = errorCode;
        this.errorException = errorException;
        this.errorMessage = errorMessage;
        this.errorMessageDetail = errorMessageDetail;
        this.frontVersion = frontVersion;
        this.callFrom = callFrom;
        this.specificHeaders = specificHeaders;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setDeviceIdentifier(String deviceIdentifier) {
        this.deviceIdentifier = deviceIdentifier;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    public void setDeviceSystem(String deviceSystem) {
        this.deviceSystem = deviceSystem;
    }

    public void setDeviceClass(String deviceClass) {
        this.deviceClass = deviceClass;
    }

    public void setDeviceVersion(String deviceVersion) {
        this.deviceVersion = deviceVersion;
    }

    public void setDeviceOsVersion(String deviceOsVersion) {
        this.deviceOsVersion = deviceOsVersion;
    }

    public void setDeviceNetworkType(String deviceNetworkType) {
        this.deviceNetworkType = deviceNetworkType;
    }

    public void setDeviceNetworkSpeedDown(String deviceNetworkSpeedDown) {
        this.deviceNetworkSpeedDown = deviceNetworkSpeedDown;
    }

    public void setDeviceNetworkSpeedUp(String deviceNetworkSpeedUp) {
        this.deviceNetworkSpeedUp = deviceNetworkSpeedUp;
    }

    public void setDeviceNetworkSpeedLatency(String deviceNetworkSpeedLatency) {
        this.deviceNetworkSpeedLatency = deviceNetworkSpeedLatency;
    }

    public void setDeviceIp(String deviceIp) {
        this.deviceIp = deviceIp;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorException(String errorException) {
        this.errorException = errorException;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setErrorMessageDetail(String errorMessageDetail) {
        this.errorMessageDetail = errorMessageDetail;
    }

    public void setFrontVersion(String frontVersion) {
        this.frontVersion = frontVersion;
    }

    public void setCallFrom(String callFrom) {
        this.callFrom = callFrom;
    }

    public void setSpecificHeaders(Set<String> specificHeaders) {
        this.specificHeaders = specificHeaders;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getToken() {
        return this.token;
    }

    public String getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceSystem() {
        return this.deviceSystem;
    }

    public String getDeviceClass() {
        return this.deviceClass;
    }

    public String getDeviceVersion() {
        return this.deviceVersion;
    }

    public String getDeviceOsVersion() {
        return this.deviceOsVersion;
    }

    public String getDeviceNetworkType() {
        return this.deviceNetworkType;
    }

    public String getDeviceNetworkSpeedDown() {
        return this.deviceNetworkSpeedDown;
    }

    public String getDeviceNetworkSpeedUp() {
        return this.deviceNetworkSpeedUp;
    }

    public String getDeviceNetworkSpeedLatency() {
        return this.deviceNetworkSpeedLatency;
    }

    public String getDeviceIp() {
        return this.deviceIp;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getWarning() {
        return this.warning;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorException() {
        return this.errorException;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorMessageDetail() {
        return this.errorMessageDetail;
    }

    public String getFrontVersion() {
        return this.frontVersion;
    }

    public String getCallFrom() {
        return this.callFrom;
    }

    public Set<String> getSpecificHeaders() {
        return this.specificHeaders;
    }

    public static class HeadersBuilder {
        private String correlationId;
        private String requestId;
        private String traceId;
        private String conversationId;
        private String token;
        private String deviceIdentifier;
        private String deviceType;
        private String deviceSystem;
        private String deviceClass;
        private String deviceVersion;
        private String deviceOsVersion;
        private String deviceNetworkType;
        private String deviceNetworkSpeedDown;
        private String deviceNetworkSpeedUp;
        private String deviceNetworkSpeedLatency;
        private String deviceIp;
        private String userAgent;
        private String language;
        private String country;
        private String warning;
        private String errorCode;
        private String errorException;
        private String errorMessage;
        private String errorMessageDetail;
        private String frontVersion;
        private String callFrom;
        private Set<String> specificHeaders;

        HeadersBuilder() {
        }

        public HeadersBuilder correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public HeadersBuilder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public HeadersBuilder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public HeadersBuilder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public HeadersBuilder token(String token) {
            this.token = token;
            return this;
        }

        public HeadersBuilder deviceIdentifier(String deviceIdentifier) {
            this.deviceIdentifier = deviceIdentifier;
            return this;
        }

        public HeadersBuilder deviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public HeadersBuilder deviceSystem(String deviceSystem) {
            this.deviceSystem = deviceSystem;
            return this;
        }

        public HeadersBuilder deviceClass(String deviceClass) {
            this.deviceClass = deviceClass;
            return this;
        }

        public HeadersBuilder deviceVersion(String deviceVersion) {
            this.deviceVersion = deviceVersion;
            return this;
        }

        public HeadersBuilder deviceOsVersion(String deviceOsVersion) {
            this.deviceOsVersion = deviceOsVersion;
            return this;
        }

        public HeadersBuilder deviceNetworkType(String deviceNetworkType) {
            this.deviceNetworkType = deviceNetworkType;
            return this;
        }

        public HeadersBuilder deviceNetworkSpeedDown(String deviceNetworkSpeedDown) {
            this.deviceNetworkSpeedDown = deviceNetworkSpeedDown;
            return this;
        }

        public HeadersBuilder deviceNetworkSpeedUp(String deviceNetworkSpeedUp) {
            this.deviceNetworkSpeedUp = deviceNetworkSpeedUp;
            return this;
        }

        public HeadersBuilder deviceNetworkSpeedLatency(String deviceNetworkSpeedLatency) {
            this.deviceNetworkSpeedLatency = deviceNetworkSpeedLatency;
            return this;
        }

        public HeadersBuilder deviceIp(String deviceIp) {
            this.deviceIp = deviceIp;
            return this;
        }

        public HeadersBuilder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public HeadersBuilder language(String language) {
            this.language = language;
            return this;
        }

        public HeadersBuilder country(String country) {
            this.country = country;
            return this;
        }

        public HeadersBuilder warning(String warning) {
            this.warning = warning;
            return this;
        }

        public HeadersBuilder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public HeadersBuilder errorException(String errorException) {
            this.errorException = errorException;
            return this;
        }

        public HeadersBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public HeadersBuilder errorMessageDetail(String errorMessageDetail) {
            this.errorMessageDetail = errorMessageDetail;
            return this;
        }

        public HeadersBuilder frontVersion(String frontVersion) {
            this.frontVersion = frontVersion;
            return this;
        }

        public HeadersBuilder callFrom(String callFrom) {
            this.callFrom = callFrom;
            return this;
        }

        public HeadersBuilder specificHeaders(Set<String> specificHeaders) {
            this.specificHeaders = specificHeaders;
            return this;
        }

        public Headers build() {
            return new Headers(this.correlationId, this.requestId, this.traceId, this.conversationId, this.token, this.deviceIdentifier, this.deviceType, this.deviceSystem, this.deviceClass, this.deviceVersion, this.deviceOsVersion, this.deviceNetworkType, this.deviceNetworkSpeedDown, this.deviceNetworkSpeedUp, this.deviceNetworkSpeedLatency, this.deviceIp, this.userAgent, this.language, this.country, this.warning, this.errorCode, this.errorException, this.errorMessage, this.errorMessageDetail, this.frontVersion, this.callFrom, this.specificHeaders);
        }

        public String toString() {
            return "Headers.HeadersBuilder(correlationId=" + this.correlationId + ", requestId=" + this.requestId + ", traceId=" + this.traceId + ", conversationId=" + this.conversationId + ", token=" + this.token + ", deviceIdentifier=" + this.deviceIdentifier + ", deviceType=" + this.deviceType + ", deviceSystem=" + this.deviceSystem + ", deviceClass=" + this.deviceClass + ", deviceVersion=" + this.deviceVersion + ", deviceOsVersion=" + this.deviceOsVersion + ", deviceNetworkType=" + this.deviceNetworkType + ", deviceNetworkSpeedDown=" + this.deviceNetworkSpeedDown + ", deviceNetworkSpeedUp=" + this.deviceNetworkSpeedUp + ", deviceNetworkSpeedLatency=" + this.deviceNetworkSpeedLatency + ", deviceIp=" + this.deviceIp + ", userAgent=" + this.userAgent + ", language=" + this.language + ", country=" + this.country + ", warning=" + this.warning + ", errorCode=" + this.errorCode + ", errorException=" + this.errorException + ", errorMessage=" + this.errorMessage + ", errorMessageDetail=" + this.errorMessageDetail + ", frontVersion=" + this.frontVersion + ", callFrom=" + this.callFrom + ", specificHeaders=" + this.specificHeaders + ")";
        }
    }
}

