/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.monitoring.models;

import io.inugami.api.models.JsonBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class IoInfoDTO {
    private static final String HEADER_SEP = " : ";
    private static final String HEADER_VALUES_SEP = ";";
    private final String url;
    private final String method;
    private final String partnerName;
    private final String partnerService;
    private final String partnerSubService;
    private final Map<String, Collection<String>> headers;
    private final Charset requestCharset;
    private final byte[] payload;
    private final int status;
    private final long duration;
    private final String message;
    private final Map<String, Collection<String>> responseHeaders;
    private final Charset responseCharset;
    private final byte[] responsePayload;

    public String toString() {
        JsonBuilder result = new JsonBuilder();
        ((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)result.write("[")).write(this.method)).write("] ")).write(this.url)).line();
        ((JsonBuilder)result.write("request:")).line();
        result.write(this.writeHeaders(this.headers));
        result.write(this.writePayload(this.payload, this.requestCharset));
        if (this.status > 0) {
            ((JsonBuilder)result.write("response:")).line();
            ((JsonBuilder)((JsonBuilder)((JsonBuilder)result.tab()).write("status: ")).write(this.status)).line();
            ((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)result.tab()).write("duration: ")).write(this.duration)).write("ms")).line();
            ((JsonBuilder)((JsonBuilder)((JsonBuilder)result.tab()).write("message: ")).write(this.message)).line();
            result.write(this.writeHeaders(this.responseHeaders));
            result.write(this.writePayload(this.responsePayload, this.responseCharset));
        }
        return result.toString();
    }

    private String writePayload(byte[] payload, Charset requestCharset) {
        JsonBuilder result = new JsonBuilder();
        if (payload == null) {
            return result.toString();
        }
        String currentValue = new String(payload, requestCharset == null ? StandardCharsets.UTF_8 : requestCharset);
        ((JsonBuilder)((JsonBuilder)result.tab()).write("payload:")).line();
        ((JsonBuilder)result.write(currentValue)).line();
        return result.toString();
    }

    private String writeHeaders(Map<String, Collection<String>> headers) {
        JsonBuilder result = new JsonBuilder();
        if (headers == null || headers.isEmpty()) {
            return result.toString();
        }
        ((JsonBuilder)((JsonBuilder)result.tab()).write("headers:")).line();
        for (Map.Entry<String, Collection<String>> entry : headers.entrySet()) {
            ((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)((JsonBuilder)result.tab()).tab()).write(entry.getKey())).write(HEADER_SEP)).write(String.join((CharSequence)HEADER_VALUES_SEP, (Iterable<? extends CharSequence>)entry.getValue()))).line();
        }
        return result.toString();
    }

    public static IoInfoDTOBuilder builder() {
        return new IoInfoDTOBuilder();
    }

    public IoInfoDTOBuilder toBuilder() {
        return new IoInfoDTOBuilder().url(this.url).method(this.method).partnerName(this.partnerName).partnerService(this.partnerService).partnerSubService(this.partnerSubService).headers(this.headers).requestCharset(this.requestCharset).payload(this.payload).status(this.status).duration(this.duration).message(this.message).responseHeaders(this.responseHeaders).responseCharset(this.responseCharset).responsePayload(this.responsePayload);
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public String getPartnerService() {
        return this.partnerService;
    }

    public String getPartnerSubService() {
        return this.partnerSubService;
    }

    public Map<String, Collection<String>> getHeaders() {
        return this.headers;
    }

    public Charset getRequestCharset() {
        return this.requestCharset;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public int getStatus() {
        return this.status;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, Collection<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public Charset getResponseCharset() {
        return this.responseCharset;
    }

    public byte[] getResponsePayload() {
        return this.responsePayload;
    }

    public IoInfoDTO(String url, String method, String partnerName, String partnerService, String partnerSubService, Map<String, Collection<String>> headers, Charset requestCharset, byte[] payload, int status, long duration, String message, Map<String, Collection<String>> responseHeaders, Charset responseCharset, byte[] responsePayload) {
        this.url = url;
        this.method = method;
        this.partnerName = partnerName;
        this.partnerService = partnerService;
        this.partnerSubService = partnerSubService;
        this.headers = headers;
        this.requestCharset = requestCharset;
        this.payload = payload;
        this.status = status;
        this.duration = duration;
        this.message = message;
        this.responseHeaders = responseHeaders;
        this.responseCharset = responseCharset;
        this.responsePayload = responsePayload;
    }

    public static class IoInfoDTOBuilder {
        private String url;
        private String method;
        private String partnerName;
        private String partnerService;
        private String partnerSubService;
        private Map<String, Collection<String>> headers;
        private Charset requestCharset;
        private byte[] payload;
        private int status;
        private long duration;
        private String message;
        private Map<String, Collection<String>> responseHeaders;
        private Charset responseCharset;
        private byte[] responsePayload;

        public IoInfoDTOBuilder addPayload(String payload) {
            if (payload != null) {
                this.payload = payload.getBytes(StandardCharsets.UTF_8);
                this.requestCharset = StandardCharsets.UTF_8;
            }
            return this;
        }

        public IoInfoDTOBuilder addResponsePayload(String payload) {
            if (payload != null) {
                this.responsePayload = payload.getBytes(StandardCharsets.UTF_8);
                this.requestCharset = StandardCharsets.UTF_8;
            }
            return this;
        }

        public IoInfoDTOBuilder addHeader(String key, String value) {
            if (this.headers == null) {
                this.headers = new LinkedHashMap<String, Collection<String>>();
            }
            if (key != null && value != null) {
                if (this.headers.containsKey(key)) {
                    Collection<String> values = this.headers.get(key);
                    ArrayList<String> newValues = new ArrayList<String>(values);
                    newValues.add(value);
                    this.headers.put(key, newValues);
                } else {
                    this.headers.put(key, List.of(value));
                }
            }
            return this;
        }

        public IoInfoDTOBuilder addHeaders(Iterator<Map.Entry<String, String>> values) {
            if (this.headers == null) {
                this.headers = new LinkedHashMap<String, Collection<String>>();
            }
            if (values != null) {
                while (values.hasNext()) {
                    Map.Entry<String, String> value = values.next();
                    this.addHeader(value.getKey(), value.getValue());
                }
            }
            return this;
        }

        IoInfoDTOBuilder() {
        }

        public IoInfoDTOBuilder url(String url) {
            this.url = url;
            return this;
        }

        public IoInfoDTOBuilder method(String method) {
            this.method = method;
            return this;
        }

        public IoInfoDTOBuilder partnerName(String partnerName) {
            this.partnerName = partnerName;
            return this;
        }

        public IoInfoDTOBuilder partnerService(String partnerService) {
            this.partnerService = partnerService;
            return this;
        }

        public IoInfoDTOBuilder partnerSubService(String partnerSubService) {
            this.partnerSubService = partnerSubService;
            return this;
        }

        public IoInfoDTOBuilder headers(Map<String, Collection<String>> headers) {
            this.headers = headers;
            return this;
        }

        public IoInfoDTOBuilder requestCharset(Charset requestCharset) {
            this.requestCharset = requestCharset;
            return this;
        }

        public IoInfoDTOBuilder payload(byte[] payload) {
            this.payload = payload;
            return this;
        }

        public IoInfoDTOBuilder status(int status) {
            this.status = status;
            return this;
        }

        public IoInfoDTOBuilder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public IoInfoDTOBuilder message(String message) {
            this.message = message;
            return this;
        }

        public IoInfoDTOBuilder responseHeaders(Map<String, Collection<String>> responseHeaders) {
            this.responseHeaders = responseHeaders;
            return this;
        }

        public IoInfoDTOBuilder responseCharset(Charset responseCharset) {
            this.responseCharset = responseCharset;
            return this;
        }

        public IoInfoDTOBuilder responsePayload(byte[] responsePayload) {
            this.responsePayload = responsePayload;
            return this;
        }

        public IoInfoDTO build() {
            return new IoInfoDTO(this.url, this.method, this.partnerName, this.partnerService, this.partnerSubService, this.headers, this.requestCharset, this.payload, this.status, this.duration, this.message, this.responseHeaders, this.responseCharset, this.responsePayload);
        }

        public String toString() {
            return "IoInfoDTO.IoInfoDTOBuilder(url=" + this.url + ", method=" + this.method + ", partnerName=" + this.partnerName + ", partnerService=" + this.partnerService + ", partnerSubService=" + this.partnerSubService + ", headers=" + this.headers + ", requestCharset=" + this.requestCharset + ", payload=" + Arrays.toString(this.payload) + ", status=" + this.status + ", duration=" + this.duration + ", message=" + this.message + ", responseHeaders=" + this.responseHeaders + ", responseCharset=" + this.responseCharset + ", responsePayload=" + Arrays.toString(this.responsePayload) + ")";
        }
    }
}

