/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.monitoring.models;

import io.inugami.api.monitoring.interceptors.MonitoringFilterInterceptor;
import io.inugami.api.monitoring.models.Headers;
import io.inugami.api.monitoring.senders.MonitoringSender;
import io.inugami.api.monitoring.sensors.MonitoringSensor;
import io.inugami.api.processors.ConfigHandler;
import java.util.ArrayList;
import java.util.List;

public class Monitoring {
    private boolean enable;
    private String env;
    private String asset;
    private String hostname;
    private String instanceName;
    private String instanceNumber;
    private String applicationVersion;
    private Headers headers;
    private int maxSensorsTasksThreads;
    private ConfigHandler<String, String> properties;
    private List<MonitoringSender> senders;
    private List<MonitoringSensor> sensors;
    private List<MonitoringFilterInterceptor> interceptors;

    public static MonitoringBuilder builder() {
        return new MonitoringBuilder();
    }

    public List<MonitoringFilterInterceptor> getInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<MonitoringFilterInterceptor>();
        }
        return this.interceptors;
    }

    public void refreshConfig(ConfigHandler<String, String> configuration) {
        this.enable = configuration.grabBoolean((Object)"inugami.monitoring.enabled", true);
        this.env = configuration.grabOrDefault((Object)"env", "dev");
        this.hostname = configuration.grabOrDefault((Object)"hostname", null);
        this.instanceName = configuration.grabOrDefault((Object)"instanceName", null);
        this.instanceNumber = configuration.grabOrDefault((Object)"instanceNumber", null);
        this.applicationVersion = configuration.grabOrDefault((Object)"version", null);
        this.maxSensorsTasksThreads = configuration.grabInt((Object)"env", Integer.valueOf(10));
        this.asset = configuration.grabOrDefault((Object)"application.application", null);
        this.properties = configuration;
        if (this.headers == null) {
            this.headers = Headers.buildFromConfig(configuration);
        } else {
            this.headers.refreshConfig(configuration);
        }
    }

    public MonitoringBuilder toBuilder() {
        return new MonitoringBuilder().enable(this.enable).env(this.env).asset(this.asset).hostname(this.hostname).instanceName(this.instanceName).instanceNumber(this.instanceNumber).applicationVersion(this.applicationVersion).headers(this.headers).maxSensorsTasksThreads(this.maxSensorsTasksThreads).properties(this.properties).senders(this.senders).sensors(this.sensors).interceptors(this.interceptors);
    }

    public Monitoring(boolean enable, String env, String asset, String hostname, String instanceName, String instanceNumber, String applicationVersion, Headers headers, int maxSensorsTasksThreads, ConfigHandler<String, String> properties, List<MonitoringSender> senders, List<MonitoringSensor> sensors, List<MonitoringFilterInterceptor> interceptors) {
        this.enable = enable;
        this.env = env;
        this.asset = asset;
        this.hostname = hostname;
        this.instanceName = instanceName;
        this.instanceNumber = instanceNumber;
        this.applicationVersion = applicationVersion;
        this.headers = headers;
        this.maxSensorsTasksThreads = maxSensorsTasksThreads;
        this.properties = properties;
        this.senders = senders;
        this.sensors = sensors;
        this.interceptors = interceptors;
    }

    public String toString() {
        return "Monitoring(enable=" + this.isEnable() + ", env=" + this.getEnv() + ", asset=" + this.getAsset() + ", hostname=" + this.getHostname() + ", instanceName=" + this.getInstanceName() + ", instanceNumber=" + this.getInstanceNumber() + ", applicationVersion=" + this.getApplicationVersion() + ", headers=" + this.getHeaders() + ", maxSensorsTasksThreads=" + this.getMaxSensorsTasksThreads() + ", properties=" + this.getProperties() + ", senders=" + this.getSenders() + ", sensors=" + this.getSensors() + ", interceptors=" + this.getInterceptors() + ")";
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setAsset(String asset) {
        this.asset = asset;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setInstanceNumber(String instanceNumber) {
        this.instanceNumber = instanceNumber;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public void setHeaders(Headers headers) {
        this.headers = headers;
    }

    public void setMaxSensorsTasksThreads(int maxSensorsTasksThreads) {
        this.maxSensorsTasksThreads = maxSensorsTasksThreads;
    }

    public void setProperties(ConfigHandler<String, String> properties) {
        this.properties = properties;
    }

    public void setSenders(List<MonitoringSender> senders) {
        this.senders = senders;
    }

    public void setSensors(List<MonitoringSensor> sensors) {
        this.sensors = sensors;
    }

    public void setInterceptors(List<MonitoringFilterInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public String getEnv() {
        return this.env;
    }

    public String getAsset() {
        return this.asset;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public int getMaxSensorsTasksThreads() {
        return this.maxSensorsTasksThreads;
    }

    public ConfigHandler<String, String> getProperties() {
        return this.properties;
    }

    public List<MonitoringSender> getSenders() {
        return this.senders;
    }

    public List<MonitoringSensor> getSensors() {
        return this.sensors;
    }

    public static class MonitoringBuilder {
        private boolean enable;
        private String env;
        private String asset;
        private String hostname;
        private String instanceName;
        private String instanceNumber;
        private String applicationVersion;
        private Headers headers;
        private int maxSensorsTasksThreads;
        private ConfigHandler<String, String> properties;
        private List<MonitoringSender> senders;
        private List<MonitoringSensor> sensors;
        private List<MonitoringFilterInterceptor> interceptors;

        public Monitoring build() {
            return new Monitoring(this.enable, this.env, this.asset, this.hostname, this.instanceName, this.instanceNumber, this.applicationVersion, this.headers, this.maxSensorsTasksThreads, this.properties, this.senders == null ? new ArrayList() : this.senders, this.sensors == null ? new ArrayList() : this.sensors, this.interceptors == null ? new ArrayList() : this.interceptors);
        }

        MonitoringBuilder() {
        }

        public MonitoringBuilder enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public MonitoringBuilder env(String env) {
            this.env = env;
            return this;
        }

        public MonitoringBuilder asset(String asset) {
            this.asset = asset;
            return this;
        }

        public MonitoringBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public MonitoringBuilder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public MonitoringBuilder instanceNumber(String instanceNumber) {
            this.instanceNumber = instanceNumber;
            return this;
        }

        public MonitoringBuilder applicationVersion(String applicationVersion) {
            this.applicationVersion = applicationVersion;
            return this;
        }

        public MonitoringBuilder headers(Headers headers) {
            this.headers = headers;
            return this;
        }

        public MonitoringBuilder maxSensorsTasksThreads(int maxSensorsTasksThreads) {
            this.maxSensorsTasksThreads = maxSensorsTasksThreads;
            return this;
        }

        public MonitoringBuilder properties(ConfigHandler<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public MonitoringBuilder senders(List<MonitoringSender> senders) {
            this.senders = senders;
            return this;
        }

        public MonitoringBuilder sensors(List<MonitoringSensor> sensors) {
            this.sensors = sensors;
            return this;
        }

        public MonitoringBuilder interceptors(List<MonitoringFilterInterceptor> interceptors) {
            this.interceptors = interceptors;
            return this;
        }

        public String toString() {
            return "Monitoring.MonitoringBuilder(enable=" + this.enable + ", env=" + this.env + ", asset=" + this.asset + ", hostname=" + this.hostname + ", instanceName=" + this.instanceName + ", instanceNumber=" + this.instanceNumber + ", applicationVersion=" + this.applicationVersion + ", headers=" + this.headers + ", maxSensorsTasksThreads=" + this.maxSensorsTasksThreads + ", properties=" + this.properties + ", senders=" + this.senders + ", sensors=" + this.sensors + ", interceptors=" + this.interceptors + ")";
        }
    }
}

