/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.monitoring.threads;

import io.inugami.api.models.tools.Chrono;
import io.inugami.api.monitoring.MdcService;
import io.inugami.api.monitoring.threads.MonitoredCallableListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class MonitoredCallable<T>
implements Callable<T> {
    private final Map<String, Serializable> mdc;
    private final List<MonitoredCallableListener> listeners;
    private final Callable<T> callable;

    @Override
    public T call() throws Exception {
        if (this.mdc != null) {
            MdcService.getInstance().setMdc(this.mdc);
        }
        this.invokeListenerOnStart();
        Chrono chrono = Chrono.startChrono();
        Throwable error = null;
        T result = null;
        try {
            result = this.callable == null ? null : (T)this.callable.call();
        }
        catch (Throwable e) {
            error = e;
            throw e;
        }
        finally {
            chrono.stop();
            this.invokeListenerOnDone(result, chrono, error);
        }
        return result;
    }

    private void invokeListenerOnStart() {
        if (this.listeners != null) {
            for (MonitoredCallableListener listener : this.listeners) {
                try {
                    listener.start(this);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void invokeListenerOnDone(T currentResult, Chrono chrono, Throwable error) {
        if (this.listeners != null) {
            for (MonitoredCallableListener listener : this.listeners) {
                try {
                    listener.done(this, currentResult, chrono, error);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static <T> MonitoredCallableBuilder<T> builder() {
        return new MonitoredCallableBuilder();
    }

    public MonitoredCallable(Map<String, Serializable> mdc, List<MonitoredCallableListener> listeners, Callable<T> callable) {
        this.mdc = mdc;
        this.listeners = listeners;
        this.callable = callable;
    }

    public static class MonitoredCallableBuilder<T> {
        private Map<String, Serializable> mdc;
        private List<MonitoredCallableListener> listeners;
        private Callable<T> callable;

        public MonitoredCallable<T> build() {
            MonitoredCallable<T> result = new MonitoredCallable<T>(MdcService.getInstance().getAllMdcExtended(), this.listeners, this.callable);
            if (this.listeners != null) {
                for (MonitoredCallableListener listener : this.listeners) {
                    try {
                        listener.created(result, System.currentTimeMillis());
                    }
                    catch (Throwable throwable) {}
                }
            }
            return result;
        }

        public MonitoredCallableBuilder<T> addListener(MonitoredCallableListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<MonitoredCallableListener>();
            }
            if (listener != null) {
                this.listeners.add(listener);
            }
            return this;
        }

        MonitoredCallableBuilder() {
        }

        public MonitoredCallableBuilder<T> mdc(Map<String, Serializable> mdc) {
            this.mdc = mdc;
            return this;
        }

        public MonitoredCallableBuilder<T> listeners(List<MonitoredCallableListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public MonitoredCallableBuilder<T> callable(Callable<T> callable) {
            this.callable = callable;
            return this;
        }

        public String toString() {
            return "MonitoredCallable.MonitoredCallableBuilder(mdc=" + this.mdc + ", listeners=" + this.listeners + ", callable=" + this.callable + ")";
        }
    }
}

