/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.processors;

import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import io.inugami.api.exceptions.Asserts;
import io.inugami.api.models.plugins.ManifestInfo;
import io.inugami.api.processors.ClassBehaviorParametersSPI;
import io.inugami.api.processors.Config;
import io.inugami.api.processors.ConfigHandler;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ClassBehavior
implements Serializable,
ClassBehaviorParametersSPI {
    private static final long serialVersionUID = -7577815562851080926L;
    @XStreamAsAttribute
    private String name;
    @XStreamAsAttribute
    private String className;
    @XStreamImplicit
    private List<Config> configs;
    private ManifestInfo manifest;

    public ClassBehavior() {
    }

    public ClassBehavior(String name, String className, Config ... configs) {
        this.name = name;
        this.className = className;
        this.configs = Arrays.asList(configs);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = this == obj;
        if (!result && obj != null && obj instanceof ClassBehavior) {
            ClassBehavior other = (ClassBehavior)obj;
            result = this.name == null ? other.getName() == null : this.name.equals(other.getName());
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName());
        builder.append("[name=");
        builder.append(this.name);
        builder.append(", className=");
        builder.append(this.className);
        builder.append(", configs=");
        if (this.configs == null) {
            builder.append("null");
        } else {
            builder.append('[');
            for (Config value : this.configs) {
                builder.append('{');
                builder.append(value.getKey());
                builder.append(':');
                builder.append(value.getValue());
                builder.append('}');
                builder.append(',');
            }
            builder.append(']');
        }
        builder.append("]");
        return builder.toString();
    }

    public List<Config> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<Config> configs) {
        this.configs = configs;
    }

    public Optional<String> getConfig(String key) {
        Asserts.assertNotNull(key, new Object[0]);
        Optional<String> result = Optional.empty();
        if (this.configs != null) {
            for (Config conf : this.configs) {
                if (!key.equals(conf.getKey())) continue;
                result = Optional.of(conf.getValue());
                break;
            }
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public ManifestInfo getManifest() {
        return this.manifest;
    }

    public void setManifest(ManifestInfo manifest) {
        this.manifest = manifest;
    }

    @Override
    public boolean accept(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T build(ClassBehavior behavior, ConfigHandler<String, String> config) {
        return (T)behavior;
    }
}

