/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.processors;

import io.inugami.api.exceptions.Asserts;
import io.inugami.api.listeners.ApplicationLifecycleSPI;
import io.inugami.api.listeners.DefaultApplicationLifecycleSPI;
import io.inugami.api.mapping.JsonUnmarshalling;
import io.inugami.api.processors.ConfigHandler;
import io.inugami.api.spi.SpiLoader;
import io.inugami.api.tools.ConfigTemplateValues;
import io.inugami.api.tools.TemplateProviderSPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;

public class DefaultConfigHandler
implements ConfigHandler<String, String>,
ApplicationLifecycleSPI {
    private static final Map<String, String> PROPERTIES = new LinkedHashMap<String, String>();
    private TemplateProviderSPI template = SpiLoader.getInstance().loadSpiServiceByPriority(TemplateProviderSPI.class, new ConfigTemplateValues());

    public DefaultConfigHandler() {
        DefaultApplicationLifecycleSPI.register(this);
        Map<String, String> env = System.getenv();
        if (env != null) {
            for (Map.Entry<String, String> entry : env.entrySet()) {
                PROPERTIES.put(entry.getKey(), entry.getValue());
            }
        }
        Properties sysProperties = System.getProperties();
        sysProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> PROPERTIES.put(String.valueOf(key), String.valueOf(value))));
    }

    public void onContextRefreshed(Object event) {
        this.template = SpiLoader.getInstance().loadSpiServiceByPriority(TemplateProviderSPI.class, new ConfigTemplateValues());
    }

    public String applyProperties(String value) {
        return value == null ? null : this.template.applyProperties(value, (Map)((Object)this));
    }

    public String grabOrDefault(String key, String defaultValue) {
        String value = PROPERTIES.get(key);
        String result = value == null ? defaultValue : value;
        return this.applyProperties(result);
    }

    public String grab(String key) {
        return this.applyProperties(PROPERTIES.get(key));
    }

    public String grab(String message, String key) {
        return this.grab(key);
    }

    public Integer grab(String key, int defaultValue) {
        String value = this.grab(key);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public Integer grabInt(String key) {
        String value = this.grab(key);
        Integer result = null;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public Integer grabInt(String key, Integer defaultValue) {
        String value = this.grab(key);
        Integer result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public long grabLong(String key, long defaultValue) {
        String value = this.grab(key);
        long result = defaultValue;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean grabBoolean(String key) {
        String value = this.grab(key);
        boolean result = false;
        if (value != null) {
            try {
                result = Boolean.parseBoolean(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean grabBoolean(String key, boolean defaultValue) {
        String value = this.grab(key);
        boolean result = defaultValue;
        if (value != null) {
            try {
                result = Boolean.parseBoolean(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public Double grab(String key, double defaultValue) {
        String value = this.grab(key);
        double result = defaultValue;
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public Double grabDouble(String key) {
        String value = this.grab(key);
        Double result = null;
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    public <T> T grabJson(String key, String json, JsonUnmarshalling unmarshaller) {
        String value = this.grab(key);
        Object result = null;
        if (value != null) {
            result = unmarshaller.process(value);
        }
        return (T)result;
    }

    public <T> T grabJson(String key, JsonUnmarshalling unmarshaller) {
        String value = this.grab(key);
        Object result = null;
        if (value != null) {
            result = unmarshaller.process(value);
        }
        return (T)result;
    }

    public <T> T grabJson(String key, Object jsonObj, JsonUnmarshalling unmarshaller) {
        String value = this.grab(key);
        Object result = null;
        if (value != null) {
            result = unmarshaller.process(value);
        }
        return (T)result;
    }

    public ConfigHandler<String, String> optionnal() {
        return this;
    }

    public List<String> grabValues(String prefix) {
        Asserts.assertNotNull("property prefix is mandatory!", prefix);
        ArrayList<String> result = new ArrayList<String>();
        Pattern regex = Pattern.compile("^" + prefix + "[.][0-9]+$");
        for (Map.Entry<String, String> entry : this.entrySet()) {
            if (!regex.matcher(entry.getKey()).matches()) continue;
            result.add(this.applyProperties(entry.getValue()));
        }
        return result;
    }

    public int size() {
        return PROPERTIES.size();
    }

    public boolean isEmpty() {
        return PROPERTIES.isEmpty();
    }

    public boolean containsKey(Object key) {
        return PROPERTIES.containsKey(String.valueOf(key));
    }

    public boolean containsValue(Object value) {
        return PROPERTIES.containsKey(String.valueOf(value));
    }

    public String get(Object key) {
        return PROPERTIES.get(String.valueOf(key));
    }

    public String put(String key, String value) {
        return PROPERTIES.put(key, value);
    }

    public String remove(Object key) {
        return PROPERTIES.remove(String.valueOf(key));
    }

    public void putAll(Map<? extends String, ? extends String> values) {
        if (values != null) {
            PROPERTIES.putAll(values);
        }
    }

    public void clear() {
        PROPERTIES.clear();
    }

    public Set<String> keySet() {
        return PROPERTIES.keySet();
    }

    public Collection<String> values() {
        return null;
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return PROPERTIES.entrySet();
    }
}

