/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.processors.fifo;

import io.inugami.api.loggers.Loggers;
import io.inugami.api.processors.fifo.FifoMapper;
import io.inugami.api.processors.fifo.FifoProcessor;
import io.inugami.api.processors.fifo.FifoProcessorGlobaleProcessor;
import io.inugami.api.providers.concurrent.LifecycleBootstrap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FifoProcessorService<Q, I>
implements LifecycleBootstrap {
    private final BlockingQueue<Q> dataToProcess = new LinkedBlockingQueue<Q>();
    private static final long DEFAULT_INTERVAL = 500L;
    private final FifoMapper<Q, I> mapper;
    private final FifoProcessor<Q> processor;
    private final ScheduledExecutorService executor;

    public FifoProcessorService(FifoMapper<Q, I> mapper, FifoProcessor<Q> processor, String threadName) {
        this(mapper, processor, 500L, threadName);
    }

    public FifoProcessorService(FifoMapper<Q, I> mapper, FifoProcessor<Q> processor, long timeToSleep, String threadName) {
        this(mapper, processor, null, timeToSleep, threadName);
    }

    public FifoProcessorService(FifoProcessorGlobaleProcessor<Q> globaleProcessor, long timeToSleep, String threadName) {
        this(null, null, globaleProcessor, timeToSleep, threadName);
    }

    public FifoProcessorService(FifoMapper<Q, I> mapper, FifoProcessorGlobaleProcessor<Q> globaleProcessor, long timeToSleep, String threadName) {
        this(mapper, null, globaleProcessor, timeToSleep, threadName);
    }

    protected FifoProcessorService(FifoMapper<Q, I> mapper, FifoProcessor<Q> processor, FifoProcessorGlobaleProcessor<Q> globaleProcessor, long interval, String threadName) {
        this.mapper = mapper != null ? mapper : input -> input;
        this.processor = processor != null ? processor : data -> {};
        long currentInterval = interval >= 0L ? interval : 500L;
        String currentThreadName = threadName != null ? threadName : String.join((CharSequence)"_", "FifoProcessorService", String.valueOf(System.identityHashCode(this)));
        this.executor = Executors.newSingleThreadScheduledExecutor(runable -> new Thread(runable, currentThreadName));
        this.executor.scheduleAtFixedRate(new FifoProcessorThread(globaleProcessor), 0L, currentInterval, TimeUnit.MILLISECONDS);
    }

    public void add(I input) {
        if (input != null) {
            Q data = this.mapper.convert(input);
            this.addData(data);
        }
    }

    private synchronized void addData(Q data) {
        this.dataToProcess.add(data);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        if (!this.executor.isShutdown()) {
            try {
                this.executor.awaitTermination(0L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                Loggers.DEBUG.error(e.getMessage(), e);
            }
        }
    }

    private class FifoProcessorThread
    implements Runnable {
        private final FifoProcessorGlobaleProcessor<Q> globaleProcessor;

        public FifoProcessorThread(FifoProcessorGlobaleProcessor<Q> globaleProcessor) {
            this.globaleProcessor = globaleProcessor;
        }

        @Override
        public void run() {
            if (this.globaleProcessor == null) {
                this.processData(FifoProcessorService.this.dataToProcess);
            } else {
                this.globaleProcessor.process(FifoProcessorService.this.dataToProcess);
            }
        }

        private void processData(BlockingQueue<Q> dataToProcess) {
            Object data;
            do {
                data = null;
                if (!dataToProcess.isEmpty()) {
                    data = dataToProcess.poll();
                }
                if (data == null) continue;
                FifoProcessorService.this.processor.process(data);
            } while (data != null);
        }
    }
}

