/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.providers;

import io.inugami.api.models.events.SimpleEvent;
import io.inugami.api.processors.ClassBehavior;
import io.inugami.api.processors.Config;
import io.inugami.api.processors.ConfigHandler;
import io.inugami.api.providers.ProviderRunner;
import io.inugami.api.providers.concurrent.FutureData;
import io.inugami.api.providers.concurrent.FutureDataBuilder;
import io.inugami.api.providers.task.ProviderFutureResult;
import io.inugami.api.providers.task.ProviderTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;

public abstract class AbstractProvider {
    private final ClassBehavior classBehavior;
    private final ConfigHandler<String, String> config;
    private final ProviderRunner providerRunner;

    protected List<Future<ProviderFutureResult>> runFutureTask(List<ProviderTask> tasks) {
        ArrayList<Future<ProviderFutureResult>> result = new ArrayList<Future<ProviderFutureResult>>();
        if (tasks != null) {
            tasks.stream().map(task -> this.providerRunner.run(this.getName(), (ProviderTask)task)).forEach(result::add);
        }
        return result;
    }

    protected Future<ProviderFutureResult> runFutureTask(ProviderTask task) {
        return this.providerRunner.run(this.getName(), task);
    }

    protected Future<ProviderFutureResult> runFutureTask(String name, ProviderTask task) {
        return this.providerRunner.run(name, task);
    }

    protected FutureData<ProviderFutureResult> runTask(ProviderTask task, SimpleEvent event, FutureData<ProviderFutureResult> future) {
        FutureDataBuilder<ProviderFutureResult> builder = new FutureDataBuilder<ProviderFutureResult>(future);
        builder.addTask(task);
        builder.addEvent(event);
        builder.addFuture(this.providerRunner.run(this.getName(), task));
        return builder.build();
    }

    public Optional<String> getConfig(String key) {
        return this.classBehavior.getConfig(key);
    }

    public String getName() {
        return this.classBehavior.getName();
    }

    public List<Config> getConfigs() {
        return this.classBehavior.getConfigs();
    }

    public ClassBehavior getClassBehavior() {
        return this.classBehavior;
    }

    public ConfigHandler<String, String> getConfig() {
        return this.config;
    }

    public ProviderRunner getProviderRunner() {
        return this.providerRunner;
    }

    protected AbstractProvider(ClassBehavior classBehavior, ConfigHandler<String, String> config, ProviderRunner providerRunner) {
        this.classBehavior = classBehavior;
        this.config = config;
        this.providerRunner = providerRunner;
    }
}

