/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.providers;

import io.inugami.api.processors.ConfigHandler;

public interface ProviderWithHttpConnector {
    public static final String HTTP_TIMEOUT = "httpTimeout";
    public static final String HTTP_SOCKET_TIMEOUT = "socketTimeout";
    public static final String HTP_TTL = "httpTTL";
    public static final String HTTP_MAX_CONNECTION = "httpMaxConnection";
    public static final String HTTP_MAX_PER_ROUTE = "httpMaxPerRoute";

    default public int getTimeout(ConfigHandler<String, String> config, int defaultValue) {
        return this.getTimeout(config, "", defaultValue);
    }

    default public int getTimeout(ConfigHandler<String, String> config, String name, int defaultValue) {
        return Integer.parseInt(config.optionnal().grabOrDefault((Object)this.buildConfigKey(HTTP_TIMEOUT, name), String.valueOf(defaultValue)));
    }

    default public int getMaxConnections(ConfigHandler<String, String> config, int defaultValue) {
        return this.getMaxConnections(config, "", defaultValue);
    }

    default public int getMaxConnections(ConfigHandler<String, String> config, String name, int defaultValue) {
        return Integer.parseInt(config.optionnal().grabOrDefault((Object)this.buildConfigKey(HTTP_MAX_CONNECTION, name), String.valueOf(defaultValue)));
    }

    default public int getTTL(ConfigHandler<String, String> config, int defaultValue) {
        return this.getTTL(config, "", defaultValue);
    }

    default public int getTTL(ConfigHandler<String, String> config, String name, int defaultValue) {
        return Integer.parseInt(config.optionnal().grabOrDefault((Object)this.buildConfigKey(HTP_TTL, name), String.valueOf(defaultValue)));
    }

    default public int getMaxPerRoute(ConfigHandler<String, String> config, int defaultValue) {
        return this.getMaxPerRoute(config, "", defaultValue);
    }

    default public int getMaxPerRoute(ConfigHandler<String, String> config, String name, int defaultValue) {
        return Integer.parseInt(config.optionnal().grabOrDefault((Object)this.buildConfigKey(HTTP_MAX_PER_ROUTE, name), String.valueOf(defaultValue)));
    }

    default public int getSocketTimeout(ConfigHandler<String, String> config, int defaultValue) {
        return this.getSocketTimeout(config, "", defaultValue);
    }

    default public int getSocketTimeout(ConfigHandler<String, String> config, String name, int defaultValue) {
        return Integer.parseInt(config.optionnal().grabOrDefault((Object)this.buildConfigKey(HTTP_SOCKET_TIMEOUT, name), String.valueOf(defaultValue)));
    }

    default public String buildConfigKey(String baseName, String name) {
        return name == null ? baseName : String.join((CharSequence)"", baseName, name);
    }
}

