/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.providers.concurrent;

import io.inugami.api.models.events.GenericEvent;
import io.inugami.api.providers.concurrent.FutureData;
import io.inugami.api.providers.concurrent.FutureDataModel;
import io.inugami.api.providers.concurrent.ImmediateFutureData;
import io.inugami.api.providers.concurrent.OnDoneFunction;
import io.inugami.api.providers.concurrent.OnErrorFunction;
import io.inugami.api.providers.task.ProviderFutureResult;
import io.inugami.api.providers.task.ProviderTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FutureDataBuilder<T> {
    private Future<T> future;
    private T data;
    private long timeout;
    private TimeUnit timeUnit;
    private List<OnErrorFunction<T>> onError = new ArrayList<OnErrorFunction<T>>();
    private List<OnDoneFunction<T>> onDone = new ArrayList<OnDoneFunction<T>>();
    private GenericEvent event;
    private ProviderTask task;
    private String channel;

    public FutureDataBuilder() {
    }

    public FutureDataBuilder(FutureData<T> futureData) {
        if (futureData != null) {
            this.future = futureData.getFuture();
            this.task = futureData.getTask();
            this.timeout = futureData.getTimeout();
            this.timeUnit = futureData.getTimeUnit();
            this.event = futureData.getEvent();
            this.onError = futureData.onError();
            this.onDone = futureData.onDone();
            this.channel = futureData.getChannel();
            this.data = futureData.getData();
        }
    }

    public FutureData<T> build() {
        return new FutureDataModel().toBuilder().future(this.future).task(this.task).timeout(this.timeout).timeUnit(this.timeUnit).event(this.event).channel(this.channel).onDone(this.onDone).onError(this.onError).data(this.data).build();
    }

    public static FutureData<ProviderFutureResult> buildDefaultFuture(long timeout) {
        return new FutureDataBuilder().addTimeout(timeout).build();
    }

    public FutureDataBuilder<T> addFuture(Future<T> future) {
        this.future = future;
        return this;
    }

    public FutureDataBuilder<T> addImmediateFuture(T data) {
        this.future = new ImmediateFutureData<T>(data);
        return this;
    }

    public FutureDataBuilder<T> addTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public FutureDataBuilder<T> addOnDone(OnDoneFunction<T> onDone) {
        this.onDone.add(onDone);
        return this;
    }

    public FutureDataBuilder<T> addOnError(OnErrorFunction<T> onError) {
        this.onError.add(onError);
        return this;
    }

    public FutureDataBuilder<T> addTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public FutureDataBuilder<T> addEvent(GenericEvent event) {
        this.event = event;
        return this;
    }

    public FutureDataBuilder<T> addTask(ProviderTask task) {
        this.task = task;
        return this;
    }

    public FutureDataBuilder<T> addChannel(String channel) {
        this.channel = channel;
        return this;
    }

    public FutureDataBuilder<T> addData(T data) {
        this.data = data;
        return this;
    }
}

