/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.providers.concurrent;

import io.inugami.api.models.events.GenericEvent;
import io.inugami.api.providers.concurrent.FutureData;
import io.inugami.api.providers.concurrent.OnDoneFunction;
import io.inugami.api.providers.concurrent.OnErrorFunction;
import io.inugami.api.providers.task.ProviderTask;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FutureDataModel<T>
implements FutureData<T> {
    private Future<T> future;
    private T data;
    private ProviderTask task;
    private GenericEvent event;
    private String channel;
    private long timeout;
    private TimeUnit timeUnit;
    private List<OnErrorFunction<T>> onError;
    private List<OnDoneFunction<T>> onDone;

    @Override
    public List<OnDoneFunction<T>> onDone() {
        return Collections.synchronizedList(this.onDone);
    }

    @Override
    public List<OnErrorFunction<T>> onError() {
        return Collections.synchronizedList(this.onError);
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit == null ? TimeUnit.MILLISECONDS : this.timeUnit;
    }

    public static <T> FutureDataModelBuilder<T> builder() {
        return new FutureDataModelBuilder();
    }

    public FutureDataModelBuilder<T> toBuilder() {
        return new FutureDataModelBuilder<T>().future(this.future).data(this.data).task(this.task).event(this.event).channel(this.channel).timeout(this.timeout).timeUnit(this.timeUnit).onError(this.onError).onDone(this.onDone);
    }

    @Override
    public Future<T> getFuture() {
        return this.future;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public ProviderTask getTask() {
        return this.task;
    }

    @Override
    public GenericEvent getEvent() {
        return this.event;
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    public List<OnErrorFunction<T>> getOnError() {
        return this.onError;
    }

    public List<OnDoneFunction<T>> getOnDone() {
        return this.onDone;
    }

    public String toString() {
        return "FutureDataModel(event=" + this.getEvent() + ", channel=" + this.getChannel() + ", timeout=" + this.getTimeout() + ", timeUnit=" + this.getTimeUnit() + ")";
    }

    public FutureDataModel() {
    }

    public FutureDataModel(Future<T> future, T data, ProviderTask task, GenericEvent event, String channel, long timeout, TimeUnit timeUnit, List<OnErrorFunction<T>> onError, List<OnDoneFunction<T>> onDone) {
        this.future = future;
        this.data = data;
        this.task = task;
        this.event = event;
        this.channel = channel;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.onError = onError;
        this.onDone = onDone;
    }

    public static class FutureDataModelBuilder<T> {
        private Future<T> future;
        private T data;
        private ProviderTask task;
        private GenericEvent event;
        private String channel;
        private long timeout;
        private TimeUnit timeUnit;
        private List<OnErrorFunction<T>> onError;
        private List<OnDoneFunction<T>> onDone;

        FutureDataModelBuilder() {
        }

        public FutureDataModelBuilder<T> future(Future<T> future) {
            this.future = future;
            return this;
        }

        public FutureDataModelBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public FutureDataModelBuilder<T> task(ProviderTask task) {
            this.task = task;
            return this;
        }

        public FutureDataModelBuilder<T> event(GenericEvent event) {
            this.event = event;
            return this;
        }

        public FutureDataModelBuilder<T> channel(String channel) {
            this.channel = channel;
            return this;
        }

        public FutureDataModelBuilder<T> timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public FutureDataModelBuilder<T> timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public FutureDataModelBuilder<T> onError(List<OnErrorFunction<T>> onError) {
            this.onError = onError;
            return this;
        }

        public FutureDataModelBuilder<T> onDone(List<OnDoneFunction<T>> onDone) {
            this.onDone = onDone;
            return this;
        }

        public FutureDataModel<T> build() {
            return new FutureDataModel<T>(this.future, this.data, this.task, this.event, this.channel, this.timeout, this.timeUnit, this.onError, this.onDone);
        }

        public String toString() {
            return "FutureDataModel.FutureDataModelBuilder(future=" + this.future + ", data=" + this.data + ", task=" + this.task + ", event=" + this.event + ", channel=" + this.channel + ", timeout=" + this.timeout + ", timeUnit=" + this.timeUnit + ", onError=" + this.onError + ", onDone=" + this.onDone + ")";
        }
    }
}

