/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.providers.task;

import io.inugami.api.alertings.AlertingResult;
import io.inugami.api.loggers.Loggers;
import io.inugami.api.models.JsonBuilder;
import io.inugami.api.models.data.basic.JsonObject;
import io.inugami.api.models.data.basic.JsonObjects;
import io.inugami.api.models.data.basic.JsonSerializerSpi;
import io.inugami.api.models.events.GenericEvent;
import io.inugami.api.spi.SpiLoader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ProviderFutureResult
implements JsonObject {
    private static final long serialVersionUID = -3593233046062751124L;
    public static final String DATA_FIELD = "data";
    private final String message;
    private final Exception exception;
    private final String scheduler;
    private final JsonObject data;
    private final GenericEvent event;
    private final String channel;
    private final String fieldData;
    private final List<AlertingResult> alerts;

    public ProviderFutureResult(String message, Exception exception, JsonObject data, GenericEvent event, String channel, String scheduler, List<AlertingResult> alerts) {
        this.message = message;
        this.exception = exception;
        this.data = data;
        this.event = event;
        this.channel = channel;
        this.scheduler = scheduler;
        this.fieldData = this.initFieldData();
        this.alerts = alerts;
    }

    protected String initFieldData() {
        return DATA_FIELD;
    }

    @Override
    public JsonObject cloneObj() {
        ArrayList<AlertingResult> newAlerts = new ArrayList<AlertingResult>();
        if (this.alerts != null) {
            newAlerts.addAll(this.alerts);
        }
        if (this.event == null) {
            Loggers.PROVIDER.error("provider send null event");
        }
        return new ProviderFutureResult(this.message, this.exception, this.data == null ? null : this.data.cloneObj(), this.event == null ? null : this.event.cloneObj(), this.channel, this.scheduler, newAlerts);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append("ProviderFutureResultModel [message=").append(this.message).append(", channel=").append(this.channel).append(", event=").append(this.event == null ? null : this.event.getName()).append(", data=").append(this.data).append(", scheduler=").append(this.scheduler).append(", event=").append(this.event).append("]");
        return builder.toString();
    }

    @Override
    public String convertToJson() {
        JsonBuilder json = new JsonBuilder();
        json.openObject();
        ((JsonBuilder)((JsonBuilder)json.addField("channel")).valueQuot(this.channel)).addSeparator();
        ((JsonBuilder)((JsonBuilder)json.addField("scheduler")).valueQuot(this.scheduler)).addSeparator();
        ((JsonBuilder)json.addField("event")).valueQuot(this.event.getName());
        if (this.exception != null) {
            json.addSeparator();
            ((JsonBuilder)json.addField("exception")).write(this.buildJsonError(this.exception));
        }
        json.addSeparator();
        json.addField("alerts");
        if (this.alerts == null || this.alerts.isEmpty()) {
            json.valueNull();
        } else {
            json.write(new JsonObjects<AlertingResult>(this.getAlerts()).convertToJson());
        }
        json.addSeparator();
        json.addField(this.fieldData);
        if (this.data == null) {
            json.valueNull();
        } else {
            String jsonData = "{}";
            String jsonDataRaw = this.data.convertToJson();
            if (jsonDataRaw != null) {
                String[] lines = jsonDataRaw.split("\n");
                StringBuilder buffer = new StringBuilder();
                for (String line : lines) {
                    buffer.append(line.trim());
                }
                jsonData = buffer.toString();
            }
            json.write(jsonData);
        }
        json.closeObject();
        return json.toString();
    }

    private String extractStack(Exception error) {
        StringWriter writer = new StringWriter();
        error.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private String buildJsonError(Exception error) {
        JsonSerializerSpi jsonSerializer = (JsonSerializerSpi)SpiLoader.getInstance().loadSpiSingleService(JsonSerializerSpi.class);
        JsonBuilder json = new JsonBuilder();
        json.openObject();
        ((JsonBuilder)json.addField("message")).valueQuot(error.getMessage());
        if (error.getCause() != null) {
            json.addSeparator();
            ((JsonBuilder)json.addField("cause")).valueQuot(error.getCause().getMessage());
        }
        json.addSeparator();
        ((JsonBuilder)json.addField("stack")).write(jsonSerializer.serialize(this.extractStack(error)));
        json.closeObject();
        return json.toString();
    }

    public Optional<String> getMessage() {
        return this.message == null ? Optional.empty() : Optional.of(this.message);
    }

    public Optional<Exception> getException() {
        return this.exception == null ? Optional.empty() : Optional.of(this.exception);
    }

    public <T extends JsonObject> Optional<T> getData() {
        return this.data == null ? Optional.empty() : Optional.of(this.data);
    }

    public GenericEvent getEvent() {
        return this.event;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getScheduler() {
        return this.scheduler;
    }

    public List<AlertingResult> getAlerts() {
        return this.alerts;
    }
}

