/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.providers.task;

import io.inugami.api.alertings.AlertingResult;
import io.inugami.api.models.Builder;
import io.inugami.api.models.data.basic.JsonObject;
import io.inugami.api.models.events.GenericEvent;
import io.inugami.api.providers.task.ProviderFutureResult;
import io.inugami.api.providers.task.ProviderFutureResultFront;
import java.util.List;

public class ProviderFutureResultBuilder
implements Builder<ProviderFutureResult> {
    private final ProviderFutureResultFront data;
    private JsonObject jsonData;

    public ProviderFutureResultBuilder() {
        this.data = new ProviderFutureResultFront();
    }

    public ProviderFutureResultBuilder(ProviderFutureResult model) {
        this.data = new ProviderFutureResultFront(model);
        if (model != null) {
            this.jsonData = model.getData().orElse(null);
        }
    }

    public ProviderFutureResultBuilder addMessage(String message) {
        this.data.setMessage(message);
        return this;
    }

    public ProviderFutureResultBuilder addException(Exception exception) {
        this.data.setException(exception);
        return this;
    }

    public ProviderFutureResultBuilder addData(JsonObject value) {
        this.jsonData = value;
        return this;
    }

    public ProviderFutureResultBuilder addEvent(GenericEvent event) {
        this.data.setEvent(event);
        return this;
    }

    public ProviderFutureResultBuilder addChannel(String channel) {
        this.data.setChannel(channel);
        return this;
    }

    public ProviderFutureResultBuilder addCronExpression(String cronExpression) {
        this.data.setCronExpression(cronExpression);
        return this;
    }

    public ProviderFutureResultBuilder addAlerts(List<AlertingResult> alerts) {
        this.data.setAlerts(alerts);
        return this;
    }

    public ProviderFutureResultBuilder addAlert(AlertingResult alert) {
        this.data.addAlert(alert);
        return this;
    }

    public ProviderFutureResult build() {
        return new ProviderFutureResult(this.data.getMessage(), this.data.getException(), this.jsonData, this.data.getEvent(), this.data.getChannel(), this.data.getCronExpression(), this.data.getAlerts());
    }

    public ProviderFutureResultFront buildForFront() {
        this.data.setData(this.jsonData == null ? null : this.jsonData.convertToJson());
        return this.data;
    }
}

