/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.providers.task;

import io.inugami.api.alertings.AlertingResult;
import io.inugami.api.models.JsonBuilder;
import io.inugami.api.models.data.basic.JsonObject;
import io.inugami.api.providers.task.ProviderFutureResult;
import java.util.ArrayList;
import java.util.List;

public class SseProviderResult
implements JsonObject {
    private static final long serialVersionUID = -1676324414315300420L;
    private final String chanel;
    private final String event;
    private final String message;
    private final String errorMessage;
    private final List<AlertingResult> alerts;
    private final boolean error;
    private final JsonObject values;
    private final String scheduler;

    public SseProviderResult(ProviderFutureResult providerFutureResult) {
        this.chanel = providerFutureResult.getChannel();
        this.event = providerFutureResult.getEvent().getName();
        this.scheduler = providerFutureResult.getScheduler();
        this.message = providerFutureResult.getMessage().orElse(null);
        this.values = providerFutureResult.getData().orElse(null);
        this.error = providerFutureResult.getException().isPresent();
        this.errorMessage = providerFutureResult.getException().isPresent() ? providerFutureResult.getException().get().getMessage() : null;
        this.alerts = providerFutureResult.getAlerts();
    }

    public SseProviderResult(String chanel, String eventName, String message, String errorMessage, boolean error, JsonObject values, String scheduler, List<AlertingResult> alerts) {
        this.chanel = chanel;
        this.event = eventName;
        this.message = message;
        this.errorMessage = errorMessage;
        this.error = error;
        this.values = values;
        this.scheduler = scheduler;
        this.alerts = alerts;
    }

    @Override
    public JsonObject cloneObj() {
        ArrayList<AlertingResult> newAlerts = new ArrayList<AlertingResult>();
        if (this.alerts != null) {
            newAlerts.addAll(this.alerts);
        }
        return new SseProviderResult(this.chanel, this.event, this.message, this.errorMessage, this.error, this.values == null ? null : this.values.cloneObj(), this.scheduler, newAlerts);
    }

    @Override
    public String convertToJson() {
        JsonBuilder json = new JsonBuilder();
        json.openObject();
        ((JsonBuilder)((JsonBuilder)json.addField("chanel")).valueQuot(this.chanel)).addSeparator();
        ((JsonBuilder)((JsonBuilder)json.addField("event")).valueQuot(this.event)).addSeparator();
        ((JsonBuilder)((JsonBuilder)json.addField("scheduler")).valueQuot(this.scheduler)).addSeparator();
        ((JsonBuilder)json.addField("alerts")).writeListJsonObject(this.alerts).addSeparator();
        ((JsonBuilder)((JsonBuilder)json.addField("message")).valueQuot(this.message)).addSeparator();
        ((JsonBuilder)json.addField("errorMessage")).valueQuot(this.errorMessage);
        json.addSeparator();
        ((JsonBuilder)json.addField("error")).write(String.valueOf(this.error));
        json.addSeparator();
        json.addField("values");
        if (this.values == null) {
            json.valueNull();
        } else {
            json.write(this.values.convertToJson());
        }
        json.closeObject();
        return json.toString();
    }
}

