/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.spi;

import io.inugami.api.spi.SpiPriority;
import io.inugami.api.tools.AnnotationTools;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Comparator;

public class PriorityComparator<T>
implements Comparator<T> {
    private static final String JAVAX_PRIORITY = "javax.annotation.Priority";

    @Override
    public int compare(T ref, T value) {
        int refPriority = this.loadPriority(ref);
        int valuePriority = this.loadPriority(value);
        return Integer.compare(valuePriority, refPriority);
    }

    private int loadPriority(T object) {
        Annotation priorityAnnotation;
        Method getValue;
        Integer result;
        Annotation[] annotations = null;
        if (object != null) {
            annotations = object.getClass().getDeclaredAnnotations();
        }
        return (result = (Integer)AnnotationTools.invoke(getValue = AnnotationTools.searchMethod(priorityAnnotation = AnnotationTools.searchAnnotation(annotations, JAVAX_PRIORITY, SpiPriority.class.getName()), "value"), priorityAnnotation, new Object[0])) == null ? 0 : result;
    }
}

