/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.spi;

import io.inugami.api.exceptions.Asserts;
import io.inugami.api.loggers.Loggers;
import io.inugami.api.spi.JavaSpiLoaderServiceSPI;
import io.inugami.api.spi.NamedSpi;
import io.inugami.api.spi.PriorityComparator;
import io.inugami.api.spi.SpiLoaderServiceSPI;
import io.inugami.api.tools.AnnotationTools;
import java.lang.annotation.Annotation;
import java.util.List;

public class SpiLoader {
    private static final String JAVAX_BEAN_NAMED = "javax.inject.Named";
    private static final SpiLoader INSTANCE = new SpiLoader();
    private SpiLoaderServiceSPI loaderService = new JavaSpiLoaderServiceSPI();

    public static SpiLoader getInstance() {
        return INSTANCE;
    }

    public void reloadLoaderService(SpiLoaderServiceSPI loaderService) {
        if (loaderService != null) {
            this.loaderService = loaderService;
        }
    }

    public synchronized <T> List<T> loadSpiService(Class<?> type) {
        List result = this.loaderService.loadServices(type);
        if (result.isEmpty()) {
            Loggers.CONFIG.warn("no SPI implementation of {} found! please check your dependencies!", (Object)type.getName());
        }
        return result;
    }

    public synchronized <T> T loadSpiSingleService(Class<?> type) {
        List<T> services = this.loadSpiService(type);
        return services.isEmpty() ? null : (T)services.get(0);
    }

    public synchronized <T> List<T> loadSpiService(Class<?> type, T defaultImplementation) {
        List result = this.loaderService.loadServices(type);
        result.sort(new PriorityComparator());
        if (result.isEmpty() && defaultImplementation != null) {
            result.add(defaultImplementation);
        }
        return result;
    }

    public synchronized <T> List<T> loadSpiServicesWithDefault(Class<?> type, T defaultImplementation) {
        List result = this.loaderService.loadServices(type);
        if (defaultImplementation != null) {
            result.add(defaultImplementation);
        }
        return result;
    }

    public synchronized <T> T loadSpiServiceByPriority(Class<?> type, T defaultImplementation) {
        try {
            return this.loadSpiServicesByPriority(type, defaultImplementation).get(0);
        }
        catch (Throwable e) {
            return defaultImplementation;
        }
    }

    public synchronized <T> List<T> loadSpiServicesByPriority(Class<?> type) {
        return this.loadSpiServicesByPriority(type, null);
    }

    public synchronized <T> T loadSpiSingleServicesByPriority(Class<?> type) {
        List<Object> services = this.loadSpiServicesByPriority(type, null);
        return services == null || services.isEmpty() ? null : services.get(0);
    }

    public synchronized <T> List<T> loadSpiServicesByPriority(Class<?> type, T defaultImplementation) {
        List result = this.loaderService.loadServices(type);
        if (defaultImplementation != null) {
            result.add(defaultImplementation);
        }
        result.sort(new PriorityComparator());
        return result;
    }

    public <T> T loadSpiService(String name, Class<?> type) {
        return this.loadSpiService(name, type, true);
    }

    public synchronized <T> T loadSpiService(String name, Class<?> type, boolean mandatory) {
        T result = null;
        List<T> services = this.loadSpiService(type);
        for (T service : services) {
            Class<?> serviceClass = service.getClass();
            if (serviceClass.getName().equals(name)) {
                result = service;
            } else if (service instanceof NamedSpi && name.equals(((NamedSpi)service).getName())) {
                result = service;
            } else if (this.classHasNamedAnnotation(serviceClass)) {
                result = service;
            } else if (serviceClass.getSimpleName().equalsIgnoreCase(name)) {
                result = service;
            }
            if (result == null) continue;
            break;
        }
        if (mandatory) {
            Asserts.assertNotNull(String.format("SPI implementation found %s is mandatory!", name), result);
        }
        return result;
    }

    private boolean classHasNamedAnnotation(Class<?> serviceClass) {
        Annotation namedAnnotation = AnnotationTools.searchAnnotation(serviceClass.getDeclaredAnnotations(), JAVAX_BEAN_NAMED);
        return namedAnnotation != null;
    }

    private SpiLoader() {
    }
}

