/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.tools;

import io.inugami.api.loggers.Loggers;
import io.inugami.api.tools.FieldGetterSetter;
import io.inugami.api.tools.NamedComponent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

public final class AnnotationTools {
    private static final String JAVAX_NAMED = "javax.inject.Named";

    public static Annotation searchAnnotation(Annotation[] annotations, String ... names) {
        Annotation result = null;
        if (annotations != null) {
            for (int i = annotations.length - 1; i >= 0; --i) {
                String className = annotations[i].annotationType().getCanonicalName();
                for (String name : names) {
                    if (!name.equals(className)) continue;
                    return annotations[i];
                }
            }
        }
        return result;
    }

    public static Method searchMethod(Annotation annotation, String method) {
        if (annotation == null || method == null) {
            return null;
        }
        Method result = null;
        Class[] paramsTypes = new Class[]{};
        try {
            result = annotation.annotationType().getDeclaredMethod(method, paramsTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Loggers.DEBUG.debug(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static Method searchMethod(Class<?> objectClass, String method) {
        if (objectClass == null || method == null) {
            return null;
        }
        Method result = null;
        Class[] paramsTypes = new Class[]{};
        try {
            result = objectClass.getDeclaredMethod(method, paramsTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Loggers.DEBUG.debug(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public static <T> T invoke(Method method, Object object, Object ... params) {
        Object result = null;
        if (method != null && object != null) {
            method.setAccessible(true);
            try {
                result = method.invoke(object, params);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Loggers.DEBUG.error(e.getMessage(), (Throwable)e);
            }
        }
        return (T)result;
    }

    public static String resolveNamed(Object object) {
        if (object == null) {
            return null;
        }
        Object result = null;
        if (object instanceof NamedComponent) {
            result = ((NamedComponent)object).getName();
        } else {
            Class<?> clazz = object.getClass();
            if ("org.jboss.weld.proxy.WeldClientProxy".equals(clazz.getName())) {
                clazz = AnnotationTools.extractCdiBeanClass(object);
            }
            if (clazz == null) {
                return null;
            }
            Annotation annotation = AnnotationTools.searchAnnotation(clazz.getAnnotations(), JAVAX_NAMED);
            Method getValue = null;
            if (annotation != null) {
                getValue = AnnotationTools.searchMethod(annotation, "value");
            }
            if (getValue != null) {
                result = (String)AnnotationTools.invoke(getValue, annotation, new Object[0]);
            }
            if (result == null || ((String)result).trim().isEmpty()) {
                result = clazz.getSimpleName().substring(0, 1).toLowerCase() + clazz.getSimpleName().substring(1);
            }
        }
        return result;
    }

    static Class<?> extractCdiBeanClass(Object bean) {
        return bean == null ? null : (Class)AnnotationTools.invokeMethods(bean, "getMetadata", "getBean", "getBeanClass");
    }

    static <T> T invokeMethods(Object object, String ... methodeNames) {
        Object result = null;
        if (object != null) {
            String methodeName;
            Object currentObject = object;
            String[] stringArray = methodeNames;
            int n = stringArray.length;
            for (int i = 0; i < n && (currentObject = AnnotationTools.invokeMethod(methodeName = stringArray[i], currentObject)) != null; ++i) {
            }
            result = currentObject;
        }
        return (T)result;
    }

    static <T> T invokeMethod(String methodeName, Object currentObject) {
        Object result = null;
        Method methodToInvoke = null;
        Method[] methods = null;
        if (currentObject != null) {
            methods = currentObject.getClass().getDeclaredMethods();
        }
        if (methods != null) {
            for (Method method : methods) {
                if (!method.getName().equals(methodeName) || method.getParameterCount() != 0) continue;
                methodToInvoke = method;
            }
        }
        if (methodToInvoke != null) {
            try {
                result = methodToInvoke.invoke(currentObject, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                Loggers.DEBUG.error(e.getMessage(), (Throwable)e);
            }
        }
        return (T)result;
    }

    public static <T> List<Method> extractGetters(T instance) {
        ArrayList<Method> result = new ArrayList<Method>();
        Field[] fields = null;
        Class<?> objectClass = null;
        if (instance != null) {
            objectClass = instance.getClass();
            fields = objectClass.getDeclaredFields();
        }
        if (fields != null) {
            Method[] methods = objectClass.getDeclaredMethods();
            for (Field field : fields) {
                Method method = AnnotationTools.searchGetterMethod(field, methods);
                if (method == null) continue;
                result.add(method);
            }
        }
        return result;
    }

    private static Method searchGetterMethod(Field field, Method[] methods) {
        Object methodName = "";
        methodName = field.getType() == Boolean.TYPE ? "is" + field.getName() : "get" + field.getName();
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase((String)methodName) || method.getParameterCount() != 0) continue;
            return method;
        }
        return null;
    }

    private static Method searchSetterMethod(Field field, Method[] methods) {
        String methodName = "set" + field.getName();
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase(methodName) || method.getParameterCount() != 1) continue;
            return method;
        }
        return null;
    }

    public static <T> List<FieldGetterSetter> extractFieldGetterAndSetter(T instance) {
        ArrayList<FieldGetterSetter> result = new ArrayList<FieldGetterSetter>();
        if (instance != null) {
            Field[] fields;
            Class<?> objectClass = instance.getClass();
            for (Field field : fields = objectClass.getDeclaredFields()) {
                FieldGetterSetter info = AnnotationTools.extractFieldInfo(field, objectClass, instance);
                if (info == null) continue;
                result.add(info);
            }
        }
        return result;
    }

    private static <T> FieldGetterSetter extractFieldInfo(Field field, Class<?> objectClass, T instance) {
        if (AnnotationTools.isInvalidField(field)) {
            return null;
        }
        field.setAccessible(true);
        Object currentValue = null;
        try {
            currentValue = field.get(instance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (currentValue == null) {
            return null;
        }
        Method[] methods = objectClass.getMethods();
        Method getter = AnnotationTools.searchGetterMethod(field, methods);
        Method setter = AnnotationTools.searchSetterMethod(field, methods);
        if (getter == null || setter == null) {
            return null;
        }
        return FieldGetterSetter.builder().field(field).value(currentValue).getter(getter).setter(setter).build();
    }

    private static boolean isInvalidField(Field field) {
        return Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers());
    }

    private AnnotationTools() {
    }
}

