/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.tools;

import io.inugami.api.exceptions.Asserts;
import io.inugami.api.processors.ConfigHandler;

public final class ConfigHandlerTools {
    public static final String ENABLE = "enable";

    private ConfigHandlerTools() {
    }

    public static String grabConfig(Class<?> prefix, String key, ConfigHandler<String, String> config) {
        return ConfigHandlerTools.grabConfig(prefix, key, null, config);
    }

    public static String grabConfig(Class<?> prefix, String key, String defaultValue, ConfigHandler<String, String> config) {
        Asserts.assertNotNull(prefix, key, config);
        StringBuilder reelKey = new StringBuilder();
        reelKey.append(prefix.getSimpleName().substring(0, 1).toLowerCase());
        reelKey.append(prefix.getSimpleName().substring(1));
        reelKey.append('.');
        reelKey.append(key);
        return config.grabOrDefault((Object)reelKey.toString(), defaultValue);
    }

    public static int grabConfigInt(Class<?> prefix, String key, ConfigHandler<String, String> config, int defaultValue) {
        String value = ConfigHandlerTools.grabConfig(prefix, key, config);
        return Asserts.checkIsBlank(value) ? defaultValue : Integer.parseInt(value);
    }

    public static long grabConfigLong(Class<?> prefix, String key, ConfigHandler<String, String> config, long defaultValue) {
        String value = ConfigHandlerTools.grabConfig(prefix, key, config);
        return Asserts.checkIsBlank(value) ? defaultValue : Long.parseLong(value);
    }

    public static boolean grabConfigBoolean(Class<?> prefix, String key, ConfigHandler<String, String> config, boolean defaultValue) {
        String value = ConfigHandlerTools.grabConfig(prefix, key, config);
        return Asserts.checkIsBlank(value) ? defaultValue : Boolean.parseBoolean(value);
    }
}

