/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.tools;

import io.inugami.api.tools.TemplateProviderSPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigTemplateValues
implements TemplateProviderSPI {
    public static final String EMPTY = "";
    private final Pattern PROPERTY_REGEX = Pattern.compile("(?:[{]{2})([^}]+)(?:[}]{2})");

    public String applyProperties(String value, Map<String, String> config) {
        String result = value;
        if (value != null && config != null) {
            List<String> keys = this.searchKeys(value);
            for (String key : keys) {
                Optional<String> propValue = this.grabPropertyValue(key, config);
                if (!propValue.isPresent()) continue;
                result = this.replacePropertyValue(result, key, propValue.get());
            }
        }
        return result;
    }

    private Optional<String> grabPropertyValue(String key, Map<String, String> config) {
        Optional<String> result = Optional.empty();
        String value = config.get(key);
        if (value != null) {
            if (!this.searchKeys(value).isEmpty()) {
                value = this.applyProperties(value, config);
            }
            result = Optional.of(value);
        }
        return result;
    }

    protected String replacePropertyValue(String result, String key, String propValue) {
        String property;
        if (result == null) {
            return null;
        }
        String realKey = "[{]{2}" + key + "[}]{2}";
        String string = property = propValue == null ? EMPTY : propValue;
        if (property.contains("\\")) {
            return result.replaceAll(realKey, property.replaceAll("\\\\", "\\\\\\\\"));
        }
        return result.replaceAll(realKey, propValue);
    }

    public List<String> searchKeys(String value) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = this.PROPERTY_REGEX.matcher(value);
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }
}

