/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.tools;

import io.inugami.api.exceptions.FatalException;
import io.inugami.api.functionnals.VoidFunctionWithException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class FileWriterErrorLess
extends Writer {
    private final Writer fileWriter;

    public FileWriterErrorLess(String file) {
        this(new File(file));
    }

    public FileWriterErrorLess(File file) {
        this(file, false);
    }

    public FileWriterErrorLess(File file, boolean append) {
        try {
            this.fileWriter = new FileWriter(file, append);
        }
        catch (IOException e) {
            throw new FatalException(e.getMessage(), e);
        }
    }

    public void write(boolean value) {
        this.write(String.valueOf(value));
    }

    public void write(byte value) {
        this.write(String.valueOf(value));
    }

    @Override
    public void write(int value) {
        this.write(String.valueOf(value));
    }

    public void write(long value) {
        this.write(String.valueOf(value));
    }

    public void write(float value) {
        this.write(String.valueOf(value));
    }

    public void write(double value) {
        this.write(String.valueOf(value));
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        this.process(() -> this.fileWriter.write(cbuf, off, len));
    }

    @Override
    public void write(char[] cbuf) {
        this.process(() -> this.fileWriter.write(cbuf));
    }

    @Override
    public void write(String value) {
        this.process(() -> this.fileWriter.write(value));
    }

    @Override
    public void write(String str, int off, int len) {
        this.process(() -> this.fileWriter.write(str, off, len));
    }

    public void writeObj(Object value) {
        this.process(() -> this.fileWriter.write(String.valueOf(value)));
    }

    public void newLine() {
        this.write("\n");
    }

    public void csvSeparator() {
        this.write(";");
    }

    @Override
    public Writer append(CharSequence csq) {
        this.process(() -> this.fileWriter.append(csq));
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) {
        this.process(() -> this.fileWriter.append(csq, start, end));
        return this;
    }

    @Override
    public Writer append(char value) {
        this.process(() -> this.fileWriter.append(value));
        return this;
    }

    @Override
    public void flush() {
        this.process(this.fileWriter::flush);
    }

    @Override
    public void close() {
        this.process(this.fileWriter::close);
    }

    private void process(VoidFunctionWithException function) {
        try {
            function.process();
        }
        catch (Exception e) {
            throw new FatalException(e.getMessage(), e);
        }
    }
}

