/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.tools;

import io.inugami.api.exceptions.UncheckedException;
import io.inugami.api.functionnals.GenericActionWithException;
import io.inugami.api.loggers.Loggers;
import io.inugami.api.tools.AnnotationTools;
import io.inugami.api.tools.FieldGetterSetter;
import io.inugami.api.tools.PathUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);
    public static final String GET = "get";
    public static final String IS = "is";
    private static final long MAX_SIZE = 2000000000L;
    public static final String CLASS_FILE = ".class";
    private static final int CLASS_EXTENSION_SIZE = ".class".length();
    private static final Map<String, List<String>> JAR_SCAN_CACHE = new ConcurrentHashMap<String, List<String>>();
    private static final List<Class<?>> PRIMITIVE_TYPES = List.of(Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Long.TYPE);
    public static final String NAME = "name";
    private static final String JAR_URL = "jar:";
    private static final int JAR_URL_SIZE = "jar:".length();
    public static final String JAR_FILE = ".jar";
    public static final String PACKAGE_SEPARATOR = ".";
    public static final String EMPTY = "";
    public static final String BOOT_INF_CLASSES = "BOOT-INF/classes/";

    public static List<Object> getEnumValues(Class<?> enumClass) {
        if (enumClass == null) {
            return List.of();
        }
        Object[] values = (Object[])ReflectionUtils.runSafe(enumClass::getEnumConstants);
        return values == null ? new ArrayList() : Arrays.asList(values);
    }

    @SafeVarargs
    public static Set<Class<?>> scan(String basePackage, ClassLoader classloader, Predicate<Class<?>> ... filters) {
        try {
            return ReflectionUtils.processScan(basePackage, classloader, filters);
        }
        catch (Throwable e) {
            return Set.of();
        }
    }

    private static Set<Class<?>> processScan(String basePackage, ClassLoader classloader, Predicate<Class<?>> ... filters) throws IOException, URISyntaxException {
        LinkedHashSet result = new LinkedHashSet();
        List<String> classes = ReflectionUtils.scanAllClasses(basePackage, classloader);
        for (String className : classes) {
            Class<?> currentClass = null;
            try {
                currentClass = classloader.loadClass(className);
            }
            catch (Throwable e) {
                log.trace(e.getMessage(), e);
            }
            if (currentClass == null || !ReflectionUtils.classFiltersMatch(currentClass, filters)) continue;
            result.add(currentClass);
        }
        ArrayList buffer = new ArrayList(result);
        Collections.sort(buffer, (r, v) -> r.getName().compareTo(v.getName()));
        return new LinkedHashSet(buffer);
    }

    private static List<String> scanAllClasses(String basePackage, ClassLoader classloader) throws IOException, URISyntaxException {
        ArrayList<String> bases = new ArrayList<String>();
        Enumeration<URL> allBases = classloader.getResources(EMPTY);
        while (allBases.hasMoreElements()) {
            bases.add(PathUtils.toUnixPath(allBases.nextElement().getFile()));
        }
        Enumeration<URL> urls = classloader.getResources(basePackage == null ? PACKAGE_SEPARATOR : basePackage.replace('.', '/'));
        ArrayList<String> classes = new ArrayList<String>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            if (url.toString().startsWith(JAR_URL)) {
                classes.addAll(ReflectionUtils.scanJar(url));
                continue;
            }
            File currentFile = new File(url.getFile());
            classes.addAll(ReflectionUtils.scanAllFiles(currentFile, bases));
        }
        return classes.stream().filter(className -> className.startsWith(basePackage)).collect(Collectors.toList());
    }

    protected static List<String> scanJar(URL url) throws URISyntaxException, IOException {
        String jarFile = ReflectionUtils.resolveJarPath(url);
        String jarFileName = jarFile.substring(PathUtils.toUnixPath(jarFile).lastIndexOf("/"));
        List<String> result = JAR_SCAN_CACHE.get(jarFileName);
        if (result == null && !(result = ReflectionUtils.readJar(jarFile)).isEmpty()) {
            JAR_SCAN_CACHE.put(jarFileName, result);
        }
        return result;
    }

    private static String resolveJarPath(URL url) throws URISyntaxException {
        String result = url.toURI().toString();
        return result.contains("!") ? result.substring(0, url.toURI().toString().indexOf("!")) : result;
    }

    private static List<String> readJar(String jarFile) throws IOException {
        File file = null;
        file = jarFile.startsWith(JAR_URL) ? new File(new URL(jarFile.substring(JAR_URL_SIZE)).getFile()) : new File(new URL(jarFile).getFile());
        return ReflectionUtils.readMainJar(file);
    }

    private static List<String> readMainJar(File file) {
        List<Object> result = null;
        try (FileInputStream fileZipStream = ReflectionUtils.openFileInputStream(file);){
            String absolutPath = PathUtils.toUnixPath(file.getAbsolutePath());
            String jarFileName = absolutPath.substring(absolutPath.lastIndexOf("/"));
            result = ReflectionUtils.processReadJar(fileZipStream, jarFileName);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result == null ? new ArrayList() : result;
    }

    private static List<String> readInnerJar(ZipInputStream zip, String entryName) {
        List<Object> result = null;
        try (ByteArrayInputStream fileZipStream = new ByteArrayInputStream(ReflectionUtils.readInnerJarContent(zip));){
            String absolutPath = PathUtils.toUnixPath(entryName);
            String jarFileName = absolutPath.substring(absolutPath.lastIndexOf("/"));
            result = ReflectionUtils.processReadJar(fileZipStream, jarFileName);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result == null ? new ArrayList() : result;
    }

    private static List<String> processReadJar(InputStream fileZipStream, String jarFileName) {
        List<String> result = JAR_SCAN_CACHE.get(jarFileName);
        if (result != null) {
            return result;
        }
        result = new ArrayList<String>();
        long size = 0L;
        try (ZipInputStream zip = new ZipInputStream(fileZipStream);){
            ZipEntry entry;
            do {
                if ((entry = zip.getNextEntry()) == null) continue;
                ReflectionUtils.assertMaxSize(size += entry.getSize());
                if (entry.getName().endsWith(CLASS_FILE)) {
                    String className = entry.getName().replaceAll(BOOT_INF_CLASSES, EMPTY).replaceAll(CLASS_FILE, EMPTY).replace('/', '.');
                    result.add(className);
                    continue;
                }
                if (!entry.getName().endsWith(JAR_FILE)) continue;
                result.addAll(ReflectionUtils.readInnerJar(zip, entry.getName()));
            } while (entry != null);
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        if (!result.isEmpty()) {
            JAR_SCAN_CACHE.put(jarFileName, result);
        }
        return result;
    }

    private static void assertMaxSize(long size) {
        if (size > 2000000000L) {
            throw new UncheckedException("zip file is too big to be unzipped");
        }
    }

    private static byte[] readInnerJarContent(ZipInputStream zip) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            byte[] byArray;
            try (ByteArrayOutputStream fos = new ByteArrayOutputStream();){
                int len;
                while ((len = zip.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                byArray = fos.toByteArray();
            }
            return byArray;
        }
        finally {
            zip.closeEntry();
        }
    }

    private static FileInputStream openFileInputStream(File file) {
        FileInputStream result = null;
        try {
            result = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            ReflectionUtils.close(result);
        }
        return result;
    }

    private static List<String> scanJarPath(Path path) {
        ArrayList<String> result = new ArrayList<String>();
        if (path.endsWith(CLASS_FILE)) {
            result.add(path.toString());
        }
        while (path.iterator().hasNext()) {
            Path child = path.iterator().next();
            result.addAll(ReflectionUtils.scanJarPath(child));
        }
        return result;
    }

    private static boolean classFiltersMatch(Class<?> currentClass, Predicate<Class<?>>[] filters) {
        Predicate<Class<?>> filter;
        if (filters.length == 0) {
            return true;
        }
        boolean result = true;
        Predicate<Class<?>>[] predicateArray = filters;
        int n = predicateArray.length;
        for (int i = 0; i < n && (result = (filter = predicateArray[i]).test(currentClass)); ++i) {
        }
        return result;
    }

    protected static List<String> scanAllFiles(File currentFile, List<String> bases) {
        String base;
        String absolutPath;
        String filePath;
        ArrayList<String> result = new ArrayList<String>();
        if (!currentFile.exists()) {
            return result;
        }
        if (currentFile.isDirectory()) {
            for (File childFile : currentFile.listFiles()) {
                result.addAll(ReflectionUtils.scanAllFiles(childFile, bases));
            }
        } else if (currentFile.isFile() && (filePath = (absolutPath = PathUtils.toUnixPath(currentFile.getAbsolutePath())).replace(base = ReflectionUtils.chooseBase(absolutPath, bases), EMPTY)).endsWith(CLASS_FILE) && !filePath.contains("module-info") && !filePath.contains("package-info")) {
            result.add(filePath.substring(0, filePath.length() - CLASS_EXTENSION_SIZE).replace('/', '.'));
        }
        return result;
    }

    protected static String chooseBase(String absolutePath, List<String> bases) {
        for (String base : bases) {
            if (!absolutePath.startsWith(base)) continue;
            return base;
        }
        return EMPTY;
    }

    public static Annotation searchAnnotation(Annotation[] annotations, String ... names) {
        return AnnotationTools.searchAnnotation(annotations, names);
    }

    public static <AE extends AnnotatedElement> boolean hasAnnotation(AE annotatedElement, Class<? extends Annotation> ... annotations) {
        boolean result = false;
        if (annotatedElement != null && annotations != null) {
            for (Class<? extends Annotation> annotation : annotations) {
                boolean bl = result = annotatedElement.getDeclaredAnnotation(annotation) != null;
                if (result) break;
            }
        }
        return result;
    }

    public static <T, A extends Annotation, AE extends AnnotatedElement> T ifHasAnnotation(AE annotatedElement, Class<A> annotation, Function<A, T> handler) {
        return ReflectionUtils.ifHasAnnotation(annotatedElement, annotation, handler, null);
    }

    public static <T, A extends Annotation, AE extends AnnotatedElement> T ifHasAnnotation(AE annotatedElement, Class<A> annotation, Function<A, T> handler, Supplier<T> defaultValue) {
        Object result = null;
        if (ReflectionUtils.hasAnnotation(annotatedElement, annotation)) {
            Object v0 = result = handler == null ? null : handler.apply(annotatedElement.getDeclaredAnnotation(annotation));
        }
        if (result == null && defaultValue != null) {
            result = defaultValue.get();
        }
        return result;
    }

    public static <T, A extends Annotation, AE extends AnnotatedElement> void processOnAnnotation(AE annotatedElement, Class<A> annotationClass, Consumer<A> handler) {
        if (annotatedElement == null || annotationClass == null || handler == null) {
            return;
        }
        A annotation = annotatedElement.getDeclaredAnnotation(annotationClass);
        if (annotation != null) {
            handler.accept(annotation);
        }
    }

    public static <A extends Annotation, AE extends AnnotatedElement> A getAnnotation(AE annotatedElement, Class<A> annotation) {
        A result = null;
        if (annotatedElement != null && (result = (A)annotatedElement.getDeclaredAnnotation(annotation)) == null) {
            result = annotatedElement.getAnnotation(annotation);
        }
        if (result == null) {
            result = ReflectionUtils.searchAnnotationInInterface(annotatedElement, annotation);
        }
        return result;
    }

    public static <A extends Annotation, AE extends AnnotatedElement> A searchAnnotationInInterface(AE annotatedElement, Class<A> annotation) {
        if (annotatedElement instanceof Method) {
            return ReflectionUtils.searchAnnotationInInterfaceFromMethod((Method)annotatedElement, annotation);
        }
        if (annotatedElement instanceof Class) {
            return ReflectionUtils.searchAnnotationInInterfaceFromClass((Class)annotatedElement, annotation);
        }
        return null;
    }

    public static <A extends Annotation> A searchAnnotationInInterfaceFromMethod(Method method, Class<A> annotation) {
        if (method == null || annotation == null) {
            return null;
        }
        A result = method.getAnnotation(annotation);
        if (method.getDeclaringClass() != null && method.getDeclaringClass().getInterfaces() != null) {
            Class<?> InterfaceClass;
            Method interfaceMethod;
            Class<?>[] classArray = method.getDeclaringClass().getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (result = ReflectionUtils.searchAnnotationInInterfaceFromMethod(interfaceMethod = ReflectionUtils.searchMethodInInterface(method, InterfaceClass = classArray[i]), annotation)) == null; ++i) {
            }
        }
        return result;
    }

    public static Method searchMethodInInterface(Method method, Class<?> clazz) {
        if (method == null || clazz == null) {
            return null;
        }
        Method result = ReflectionUtils.searchMethodInClass(method, clazz);
        if (result == null && clazz.getInterfaces() != null) {
            Class<?> interfaceClass;
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (result = ReflectionUtils.searchMethodInInterface(method, interfaceClass = classArray[i])) == null; ++i) {
            }
        }
        return result;
    }

    public static Method searchMethodInClass(Method method, Class<?> clazz) {
        Method[] methods;
        if (method == null || clazz == null) {
            return null;
        }
        for (Method currentMethod : methods = clazz.getDeclaredMethods()) {
            if (!currentMethod.getName().equals(method.getName()) || currentMethod.getReturnType() != method.getReturnType() || !ReflectionUtils.isSameParameters(method.getParameters(), currentMethod.getParameters())) continue;
            return currentMethod;
        }
        return null;
    }

    private static boolean isSameParameters(Parameter[] refParameters, Parameter[] parameters) {
        if (refParameters == null && parameters == null) {
            return true;
        }
        if (refParameters == null && parameters != null || refParameters != null && parameters == null) {
            return false;
        }
        if (refParameters.length != parameters.length) {
            return false;
        }
        for (int i = 0; i < refParameters.length; ++i) {
            if (refParameters[i].getType() == parameters[i].getType()) continue;
            return false;
        }
        return true;
    }

    public static <A extends Annotation> A searchAnnotationInInterfaceFromClass(Class<?> clazz, Class<A> annotation) {
        if (clazz == null || annotation == null) {
            return null;
        }
        A result = clazz.getAnnotation(annotation);
        if (result == null && clazz.getInterfaces() != null) {
            Class<?> InterfaceClass;
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (result = ReflectionUtils.searchAnnotationInInterfaceFromClass(InterfaceClass = classArray[i], annotation)) == null; ++i) {
            }
        }
        return result;
    }

    public static Object getStaticFieldValue(String fieldName, Class<?> clazz) {
        if (fieldName == null || clazz == null) {
            return null;
        }
        Field currentField = ReflectionUtils.getField(fieldName, clazz);
        if (currentField == null) {
            return null;
        }
        currentField.setAccessible(true);
        return ReflectionUtils.runSafe(() -> currentField.get(null));
    }

    public static Object getFieldValue(String fieldName, Object instance) {
        if (fieldName == null || instance == null) {
            return null;
        }
        Field currentField = ReflectionUtils.getField(fieldName, instance);
        ReflectionUtils.setAccessible(currentField);
        return ReflectionUtils.runSafe(() -> currentField.get(instance));
    }

    public static Field getField(String fieldName, Object instance) {
        if (instance == null || fieldName == null) {
            return null;
        }
        return ReflectionUtils.getField(fieldName, instance.getClass());
    }

    public static Field getField(String fieldName, Class<?> instanceClass) {
        if (instanceClass == null || fieldName == null) {
            return null;
        }
        Field currentField = null;
        List<Field> fields = ReflectionUtils.getAllFields(instanceClass);
        for (Field classField : fields) {
            if (!classField.getName().equals(fieldName)) continue;
            currentField = classField;
            break;
        }
        return currentField;
    }

    public static List<Field> getAllFields(Class<?> instanceClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        if (instanceClass == null || instanceClass == Object.class) {
            return result;
        }
        result.addAll(Arrays.asList(instanceClass.getDeclaredFields()));
        if (instanceClass.getSuperclass() != null) {
            result.addAll(ReflectionUtils.getAllFields(instanceClass.getSuperclass()));
        }
        return result;
    }

    public static Set<Field> loadAllFields(Class<?> clazz) {
        LinkedHashSet<Field> result = new LinkedHashSet<Field>();
        try {
            if (clazz != null && clazz != Object.class) {
                result.addAll(Arrays.asList(clazz.getDeclaredFields()));
                if (clazz.getSuperclass() != null) {
                    result.addAll(ReflectionUtils.loadAllFields(clazz.getSuperclass()));
                }
            }
        }
        catch (Throwable err) {
            Loggers.DEBUG.warn(err.getMessage());
        }
        return result;
    }

    public static Set<Field> loadAllStaticFields(Class<?> clazz) {
        LinkedHashSet<Field> result = new LinkedHashSet<Field>();
        ReflectionUtils.loadAllFields(clazz).stream().filter(field -> Modifier.isStatic(field.getModifiers())).forEach(result::add);
        return result;
    }

    public static List<Field> extractParentsFields(Class<?> superclass) {
        ArrayList<Field> result = new ArrayList<Field>();
        if (superclass != null) {
            result.addAll(Arrays.asList(superclass.getDeclaredFields()));
            if (superclass.getSuperclass() != null) {
                result.addAll(ReflectionUtils.extractParentsFields(superclass.getSuperclass()));
            }
        }
        return result;
    }

    public static Field buildField(Class<?> type, String name) {
        Field field = null;
        Constructor<?> constructor = Field.class.getDeclaredConstructors()[0];
        constructor.setAccessible(true);
        try {
            field = (Field)constructor.newInstance(type, name, type, 0, 0, null, null);
        }
        catch (Exception e) {
            Loggers.DEBUG.error(e.getMessage());
        }
        return field;
    }

    public static <T> T setFieldValue(Field field, Object value, T instance) {
        if (field != null && instance != null) {
            field.setAccessible(true);
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new UncheckedException(e.getMessage(), (Throwable)e);
            }
        }
        return instance;
    }

    public static Set<Constructor<?>> loadAllConstructors(Class<?> clazz) {
        LinkedHashSet result = new LinkedHashSet();
        if (clazz == null) {
            return result;
        }
        try {
            if (clazz != Object.class) {
                result.addAll(Arrays.asList(clazz.getDeclaredConstructors()));
                if (clazz.getSuperclass() != null) {
                    result.addAll(ReflectionUtils.loadAllConstructors(clazz.getSuperclass()));
                }
            }
        }
        catch (Throwable err) {
            Loggers.DEBUG.warn(err.getMessage());
        }
        return result;
    }

    public static List<Method> loadAllMethods(Class<?> clazz) {
        ArrayList<Method> result = new ArrayList<Method>();
        if (clazz == null) {
            return result;
        }
        try {
            if (clazz != Object.class) {
                result.addAll(Arrays.asList(clazz.getDeclaredMethods()));
                if (clazz.getSuperclass() != null) {
                    result.addAll(ReflectionUtils.loadAllMethods(clazz.getSuperclass()));
                }
            }
        }
        catch (Throwable err) {
            Loggers.DEBUG.warn(err.getMessage());
        }
        return result;
    }

    public static Method searchMethod(Annotation annotation, String method) {
        return AnnotationTools.searchMethod(annotation, method);
    }

    @Deprecated(since="3.2.5")
    public static Method searchMethod(Class<?> objectClass, String method) {
        return AnnotationTools.searchMethod(objectClass, method);
    }

    public static Method searchMethodByName(Class<?> objectClass, String method) {
        Method result = null;
        if (objectClass != null) {
            return ReflectionUtils.loadAllMethods(objectClass).stream().filter(m -> m.getName().equalsIgnoreCase(method)).findFirst().orElse(null);
        }
        return result;
    }

    public static <T> List<FieldGetterSetter> extractFieldGetterAndSetter(T instance) {
        return AnnotationTools.extractFieldGetterAndSetter(instance);
    }

    public static <T> List<Method> extractGetters(T instance) {
        return AnnotationTools.extractGetters(instance);
    }

    public static void sortMethods(List<Method> methods) {
        if (methods != null) {
            Collections.sort(methods, (ref, val) -> ref.getName().compareTo(val.getName()));
        }
    }

    public static Object callGetterForField(String field, Object instance) {
        if (field == null || instance == null) {
            return null;
        }
        List<Method> methods = ReflectionUtils.loadAllMethods(instance.getClass());
        Method getter = methods.stream().filter(m -> m.getName().equalsIgnoreCase(GET + field) || m.getName().equalsIgnoreCase(IS + field)).findFirst().orElse(null);
        ReflectionUtils.setAccessible(getter);
        return ReflectionUtils.runSafe(() -> getter.invoke(instance, new Object[0]));
    }

    public static <T> T invoke(Method method, Object object, Object ... params) {
        return AnnotationTools.invoke(method, object, params);
    }

    public static <T> T invokeMethod(String methodeName, Object currentObject) {
        return AnnotationTools.invokeMethod(methodeName, currentObject);
    }

    public static <T> T invokeMethods(Object object, String ... methodeNames) {
        return AnnotationTools.invokeMethods(object, methodeNames);
    }

    public static String resolveNamed(Object object) {
        return AnnotationTools.resolveNamed(object);
    }

    public static Class<?> extractCdiBeanClass(Object bean) {
        return AnnotationTools.extractCdiBeanClass(bean);
    }

    public static void setAccessible(Method method) {
        if (method != null) {
            try {
                method.setAccessible(true);
            }
            catch (Throwable e) {
                ReflectionUtils.traceError(e, log);
            }
        }
    }

    public static void setAccessible(Field field) {
        if (field != null) {
            try {
                field.setAccessible(true);
            }
            catch (Throwable e) {
                ReflectionUtils.traceError(e, log);
            }
        }
    }

    public static boolean isBasicType(Class<?> currentClass) {
        return currentClass == null ? true : PRIMITIVE_TYPES.contains(currentClass) || currentClass.getName().startsWith("java.lang", 0);
    }

    public static Class<?> getGenericType(Type type) {
        ParameterizedType paramType;
        Type[] argTypes;
        Class<?> result = null;
        if (type instanceof ParameterizedType && (argTypes = (paramType = (ParameterizedType)type).getActualTypeArguments()).length > 0) {
            result = argTypes[0].getClass();
        }
        return result;
    }

    public static Class<?> extractGenericType(Type genericType) {
        return ReflectionUtils.extractGenericType(genericType, 0);
    }

    public static Class<?> extractGenericType(Type genericType, int typeIndex) {
        Class<?> result = null;
        if (genericType != null) {
            if (genericType instanceof ParameterizedType) {
                String className = ((ParameterizedType)genericType).getActualTypeArguments()[typeIndex].getTypeName();
                try {
                    result = ReflectionUtils.getClassloader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    log.error("no class def found : {}", (Object)genericType);
                }
            } else if (genericType instanceof Class) {
                result = (Class<?>)genericType;
            }
        }
        return result;
    }

    private static ClassLoader getClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static int parseInt(Object value) {
        int result = 500;
        try {
            result = (Integer)value;
        }
        catch (Throwable e) {
            ReflectionUtils.traceError(e, log);
        }
        return result;
    }

    public static <T> T runSafe(GenericActionWithException<T> action) {
        if (action == null) {
            return null;
        }
        try {
            return (T)action.process();
        }
        catch (Throwable e) {
            ReflectionUtils.traceError(e, log);
            return null;
        }
    }

    public static void traceError(Throwable e, Logger logger) {
        if (logger.isDebugEnabled()) {
            if (e instanceof ClassNotFoundException) {
                logger.error(e.getMessage());
            } else {
                logger.error(e.getMessage(), e);
            }
        }
    }

    public static Map<String, Map<String, Object>> convertEnumToMap(Class<? extends Enum<?>> enumClass) {
        if (enumClass == null) {
            return Map.of();
        }
        LinkedHashMap<String, Map<String, Object>> result = new LinkedHashMap<String, Map<String, Object>>();
        Enum<?>[] values = enumClass.getEnumConstants();
        try {
            for (Enum<?> enumItem : values) {
                Map<String, Object> enumFields = ReflectionUtils.extractEnumFields(enumItem);
                result.put(enumItem.name(), enumFields);
            }
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static Map<String, Object> extractEnumFields(Enum<?> enumItem) throws IllegalAccessException {
        Field[] fields;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Field field : fields = enumItem.getDeclaringClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            result.put(field.getName(), field.get(enumItem));
        }
        return result;
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

