/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions;

import io.inugami.api.exceptions.DefaultErrorCode;
import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.ExceptionWithErrorCode;
import io.inugami.api.exceptions.MessagesFormatter;

public class CheckedException
extends Exception
implements ExceptionWithErrorCode {
    private static final long serialVersionUID = -7629698090833397665L;
    private final transient ErrorCode errorCode;

    public CheckedException(int code, String message, Throwable cause) {
        this(DefaultErrorCode.builder().statusCode(code).build(), cause, message, new Object[0]);
    }

    public CheckedException(ErrorCode errorCode, Throwable cause) {
        super(errorCode == null ? DefaultErrorCode.buildUndefineError().getMessage() : errorCode.getMessage(), cause);
        this.errorCode = errorCode == null ? DefaultErrorCode.buildUndefineError() : errorCode;
    }

    public CheckedException() {
        this(null, null, null);
    }

    public CheckedException(String message, Throwable cause) {
        this(null, cause, message, null);
    }

    public CheckedException(String message, Object ... values) {
        this(null, null, message, values);
    }

    public CheckedException(Throwable cause, String message, Object ... values) {
        this(null, cause, message, values);
    }

    public CheckedException(String message) {
        this(null, null, message, null);
    }

    public CheckedException(Throwable cause) {
        this(null, cause, cause.getMessage(), null);
    }

    public CheckedException(ErrorCode errorCode) {
        this(errorCode, null, errorCode == null ? null : errorCode.getMessage(), null);
    }

    public CheckedException(ErrorCode errorCode, String message) {
        this(errorCode, null, message, null);
    }

    public CheckedException(ErrorCode errorCode, Throwable cause, String message, Object ... values) {
        super(MessagesFormatter.format(message, values), cause);
        this.errorCode = errorCode == null ? DefaultErrorCode.buildUndefineError() : errorCode;
    }

    public int getCode() {
        return this.errorCode.getStatusCode();
    }

    @Override
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }
}

