/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions;

import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.MessagesFormatter;
import java.io.Serializable;
import java.util.function.BiConsumer;

public final class DefaultErrorCode
implements Serializable,
ErrorCode {
    private static final long serialVersionUID = -3438361352478852714L;
    private final int statusCode;
    private final String errorCode;
    private final String message;
    private final String messageDetail;
    private final String errorType;
    private final boolean retryable;
    private final boolean rollback;
    private final String payload;
    private final String category;
    private final String domain;
    private final String subDomain;
    private final String url;
    private final boolean exploitationError;
    private final String field;
    private final transient BiConsumer<String, Exception> errorHandler;

    public static ErrorCode buildUndefineError() {
        return DefaultErrorCode.builder().statusCode(500).errorCode("err-undefine").errorTypeTechnical().build();
    }

    public static DefaultErrorCodeBuilder buildUndefineErrorCode() {
        return DefaultErrorCode.fromErrorCode(DefaultErrorCode.buildUndefineError());
    }

    public static DefaultErrorCodeBuilder fromErrorCode(ErrorCode errorCode) {
        DefaultErrorCodeBuilder result = DefaultErrorCode.builder();
        ErrorCode currentErrorCode = errorCode == null ? DefaultErrorCode.buildUndefineError() : errorCode;
        return result.errorCode(currentErrorCode.getErrorCode()).statusCode(currentErrorCode.getStatusCode()).message(currentErrorCode.getMessage()).errorType(currentErrorCode.getErrorType()).payload(currentErrorCode.getPayload()).errorHandler(currentErrorCode.getErrorHandler()).exploitationError(currentErrorCode.isExploitationError()).retryable(currentErrorCode.isRetryable()).rollback(currentErrorCode.isRollbackRequire()).category(currentErrorCode.getCategory()).field(currentErrorCode.getField()).url(currentErrorCode.getUrl()).domain(currentErrorCode.getDomain()).subDomain(currentErrorCode.getSubDomain());
    }

    public static DefaultErrorCodeBuilder newBuilder() {
        return DefaultErrorCode.builder();
    }

    @Override
    public ErrorCode getCurrentErrorCode() {
        return this;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getMessageDetail() {
        return this.messageDetail;
    }

    @Override
    public String getErrorType() {
        return this.errorType;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public BiConsumer<String, Exception> getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean isExploitationError() {
        return this.exploitationError;
    }

    @Override
    public boolean isRollbackRequire() {
        return this.rollback;
    }

    @Override
    public boolean isRetryable() {
        return this.retryable;
    }

    @Override
    public String getField() {
        return this.field;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getSubDomain() {
        return this.subDomain;
    }

    public static DefaultErrorCodeBuilder builder() {
        return new DefaultErrorCodeBuilder();
    }

    @Override
    public DefaultErrorCodeBuilder toBuilder() {
        return new DefaultErrorCodeBuilder().statusCode(this.statusCode).errorCode(this.errorCode).message(this.message).messageDetail(this.messageDetail).errorType(this.errorType).retryable(this.retryable).rollback(this.rollback).payload(this.payload).category(this.category).domain(this.domain).subDomain(this.subDomain).url(this.url).exploitationError(this.exploitationError).field(this.field).errorHandler(this.errorHandler);
    }

    public String toString() {
        return "DefaultErrorCode(statusCode=" + this.getStatusCode() + ", errorCode=" + this.getErrorCode() + ", message=" + this.getMessage() + ", messageDetail=" + this.getMessageDetail() + ", errorType=" + this.getErrorType() + ", retryable=" + this.isRetryable() + ", rollback=" + this.isRollback() + ", payload=" + this.getPayload() + ", category=" + this.getCategory() + ", domain=" + this.getDomain() + ", subDomain=" + this.getSubDomain() + ", url=" + this.getUrl() + ", exploitationError=" + this.isExploitationError() + ", field=" + this.getField() + ", errorHandler=" + this.getErrorHandler() + ")";
    }

    public boolean isRollback() {
        return this.rollback;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public DefaultErrorCode(int statusCode, String errorCode, String message, String messageDetail, String errorType, boolean retryable, boolean rollback, String payload, String category, String domain, String subDomain, String url, boolean exploitationError, String field, BiConsumer<String, Exception> errorHandler) {
        this.statusCode = statusCode;
        this.errorCode = errorCode;
        this.message = message;
        this.messageDetail = messageDetail;
        this.errorType = errorType;
        this.retryable = retryable;
        this.rollback = rollback;
        this.payload = payload;
        this.category = category;
        this.domain = domain;
        this.subDomain = subDomain;
        this.url = url;
        this.exploitationError = exploitationError;
        this.field = field;
        this.errorHandler = errorHandler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultErrorCode)) {
            return false;
        }
        DefaultErrorCode other = (DefaultErrorCode)o;
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        return !(this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        return result;
    }

    public static class DefaultErrorCodeBuilder {
        private int statusCode;
        private String errorCode;
        private String message;
        private String messageDetail;
        private String errorType;
        private boolean retryable;
        private boolean rollback;
        private String payload;
        private String category;
        private String domain;
        private String subDomain;
        private String url;
        private boolean exploitationError;
        private String field;
        private BiConsumer<String, Exception> errorHandler;

        public DefaultErrorCodeBuilder errorTypeTechnical() {
            this.errorType = "technical";
            return this;
        }

        public DefaultErrorCodeBuilder errorTypeFunctional() {
            this.errorType = "functional";
            return this;
        }

        public DefaultErrorCodeBuilder errorTypeConfiguration() {
            this.errorType = "configuration";
            return this;
        }

        public DefaultErrorCodeBuilder errorTypeSecurity() {
            this.errorType = "security";
            return this;
        }

        public DefaultErrorCodeBuilder exploitationError() {
            this.exploitationError = true;
            return this;
        }

        public DefaultErrorCodeBuilder exploitationError(boolean value) {
            this.exploitationError = value;
            return this;
        }

        public DefaultErrorCodeBuilder addMessageDetail(String message, Object ... values) {
            if (message != null) {
                this.messageDetail = MessagesFormatter.format(message, values);
            }
            return this;
        }

        public DefaultErrorCodeBuilder rollbackRequire() {
            this.rollback = true;
            return this;
        }

        public DefaultErrorCodeBuilder isRetryable() {
            this.retryable = true;
            return this;
        }

        DefaultErrorCodeBuilder() {
        }

        public DefaultErrorCodeBuilder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public DefaultErrorCodeBuilder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public DefaultErrorCodeBuilder message(String message) {
            this.message = message;
            return this;
        }

        public DefaultErrorCodeBuilder messageDetail(String messageDetail) {
            this.messageDetail = messageDetail;
            return this;
        }

        public DefaultErrorCodeBuilder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public DefaultErrorCodeBuilder retryable(boolean retryable) {
            this.retryable = retryable;
            return this;
        }

        public DefaultErrorCodeBuilder rollback(boolean rollback) {
            this.rollback = rollback;
            return this;
        }

        public DefaultErrorCodeBuilder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public DefaultErrorCodeBuilder category(String category) {
            this.category = category;
            return this;
        }

        public DefaultErrorCodeBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public DefaultErrorCodeBuilder subDomain(String subDomain) {
            this.subDomain = subDomain;
            return this;
        }

        public DefaultErrorCodeBuilder url(String url) {
            this.url = url;
            return this;
        }

        public DefaultErrorCodeBuilder field(String field) {
            this.field = field;
            return this;
        }

        public DefaultErrorCodeBuilder errorHandler(BiConsumer<String, Exception> errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public DefaultErrorCode build() {
            return new DefaultErrorCode(this.statusCode, this.errorCode, this.message, this.messageDetail, this.errorType, this.retryable, this.rollback, this.payload, this.category, this.domain, this.subDomain, this.url, this.exploitationError, this.field, this.errorHandler);
        }

        public String toString() {
            return "DefaultErrorCode.DefaultErrorCodeBuilder(statusCode=" + this.statusCode + ", errorCode=" + this.errorCode + ", message=" + this.message + ", messageDetail=" + this.messageDetail + ", errorType=" + this.errorType + ", retryable=" + this.retryable + ", rollback=" + this.rollback + ", payload=" + this.payload + ", category=" + this.category + ", domain=" + this.domain + ", subDomain=" + this.subDomain + ", url=" + this.url + ", exploitationError=" + this.exploitationError + ", field=" + this.field + ", errorHandler=" + this.errorHandler + ")";
        }
    }
}

