/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions;

import io.inugami.api.exceptions.MessagesFormatter;
import io.inugami.api.exceptions.Warning;

public final class DefaultWarning
implements Warning {
    private final String warningCode;
    private final String message;
    private final String messageDetail;
    private final String warningType;
    private final String category;
    private final String domain;
    private final String subDomain;

    public static DefaultWarningBuilder fromWarningCode(Warning warning) {
        DefaultWarningBuilder builder = DefaultWarning.builder();
        if (warning != null) {
            builder.warningCode(warning.getWarningCode());
            builder.message(warning.getMessage());
            builder.messageDetail(warning.getMessageDetail());
            builder.warningType(warning.getWarningType());
            builder.category(warning.getCategory());
            builder.domain(warning.getDomain());
            builder.subDomain(warning.getSubDomain());
        }
        return builder;
    }

    @Override
    public Warning getCurrentWaring() {
        return this;
    }

    @Override
    public String getWarningCode() {
        return this.warningCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getMessageDetail() {
        return this.messageDetail;
    }

    @Override
    public String getWarningType() {
        return this.warningType;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public String getSubDomain() {
        return this.subDomain;
    }

    public static DefaultWarningBuilder builder() {
        return new DefaultWarningBuilder();
    }

    @Override
    public DefaultWarningBuilder toBuilder() {
        return new DefaultWarningBuilder().warningCode(this.warningCode).message(this.message).messageDetail(this.messageDetail).warningType(this.warningType).category(this.category).domain(this.domain).subDomain(this.subDomain);
    }

    public String toString() {
        return "DefaultWarning(warningCode=" + this.getWarningCode() + ", message=" + this.getMessage() + ", messageDetail=" + this.getMessageDetail() + ", warningType=" + this.getWarningType() + ", category=" + this.getCategory() + ", domain=" + this.getDomain() + ", subDomain=" + this.getSubDomain() + ")";
    }

    public DefaultWarning(String warningCode, String message, String messageDetail, String warningType, String category, String domain, String subDomain) {
        this.warningCode = warningCode;
        this.message = message;
        this.messageDetail = messageDetail;
        this.warningType = warningType;
        this.category = category;
        this.domain = domain;
        this.subDomain = subDomain;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultWarning)) {
            return false;
        }
        DefaultWarning other = (DefaultWarning)o;
        String this$warningCode = this.getWarningCode();
        String other$warningCode = other.getWarningCode();
        return !(this$warningCode == null ? other$warningCode != null : !this$warningCode.equals(other$warningCode));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $warningCode = this.getWarningCode();
        result = result * 59 + ($warningCode == null ? 43 : $warningCode.hashCode());
        return result;
    }

    public static class DefaultWarningBuilder {
        private String warningCode;
        private String message;
        private String messageDetail;
        private String warningType;
        private String category;
        private String domain;
        private String subDomain;

        public DefaultWarningBuilder addMessageDetail(String message, Object ... values) {
            if (message != null) {
                this.messageDetail = MessagesFormatter.format(message, values);
            }
            return this;
        }

        public DefaultWarningBuilder typeFunctional() {
            this.warningType = "functional";
            return this;
        }

        public DefaultWarningBuilder typeTechnical() {
            this.warningType = "technical";
            return this;
        }

        public DefaultWarningBuilder typeSecurity() {
            this.warningType = "security";
            return this;
        }

        public DefaultWarningBuilder typeFeature() {
            this.warningType = "feature";
            return this;
        }

        DefaultWarningBuilder() {
        }

        public DefaultWarningBuilder warningCode(String warningCode) {
            this.warningCode = warningCode;
            return this;
        }

        public DefaultWarningBuilder message(String message) {
            this.message = message;
            return this;
        }

        public DefaultWarningBuilder messageDetail(String messageDetail) {
            this.messageDetail = messageDetail;
            return this;
        }

        public DefaultWarningBuilder warningType(String warningType) {
            this.warningType = warningType;
            return this;
        }

        public DefaultWarningBuilder category(String category) {
            this.category = category;
            return this;
        }

        public DefaultWarningBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public DefaultWarningBuilder subDomain(String subDomain) {
            this.subDomain = subDomain;
            return this;
        }

        public DefaultWarning build() {
            return new DefaultWarning(this.warningCode, this.message, this.messageDetail, this.warningType, this.category, this.domain, this.subDomain);
        }

        public String toString() {
            return "DefaultWarning.DefaultWarningBuilder(warningCode=" + this.warningCode + ", message=" + this.message + ", messageDetail=" + this.messageDetail + ", warningType=" + this.warningType + ", category=" + this.category + ", domain=" + this.domain + ", subDomain=" + this.subDomain + ")";
        }
    }
}

