/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions;

import io.inugami.api.exceptions.DefaultErrorCode;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public interface ErrorCode {
    public static final String STATUS_CODE = "errorStatus";
    public static final String ERROR_CODE = "errorCode";
    public static final String MESSAGE = "message";
    public static final String MESSAGE_DETAIL = "messageDetail";
    public static final String ERROR_TYPE = "errorType";
    public static final String PAYLOAD = "payload";
    public static final String EXPLOITATION_ERROR = "exploitationError";
    public static final String ROLLBACK = "rollback";
    public static final String RETRYABLE = "retryable";
    public static final String FIELD = "field";
    public static final String URL = "url";
    public static final String CATEGORY = "category";
    public static final String DOMAIN = "errorDomain";
    public static final String SUB_DOMAIN = "errorSubDomain";
    public static final String ERROR_HANDLER = "errorHandler";
    public static final List<String> KEYS_SET = List.of("errorStatus", "errorCode", "message", "messageDetail", "errorType", "payload", "exploitationError", "rollback", "retryable", "field", "url", "category", "errorDomain", "errorSubDomain");

    public ErrorCode getCurrentErrorCode();

    default public int getStatusCode() {
        return this.getCurrentErrorCode() == null ? 500 : (this.getCurrentErrorCode().getStatusCode() < 400 ? 500 : this.getCurrentErrorCode().getStatusCode());
    }

    default public String getErrorCode() {
        return this.getCurrentErrorCode() == null ? "undefine" : this.getCurrentErrorCode().getErrorCode();
    }

    default public String getMessage() {
        return this.getCurrentErrorCode() == null ? "error" : this.getCurrentErrorCode().getMessage();
    }

    default public String getMessageDetail() {
        return this.getCurrentErrorCode() == null ? null : this.getCurrentErrorCode().getMessageDetail();
    }

    default public boolean isExploitationError() {
        return this.getCurrentErrorCode() == null ? false : this.getCurrentErrorCode().isExploitationError();
    }

    default public String getErrorType() {
        return this.getCurrentErrorCode() == null ? "technical" : this.getCurrentErrorCode().getErrorType();
    }

    default public String getDomain() {
        return this.getCurrentErrorCode() == null ? null : this.getCurrentErrorCode().getDomain();
    }

    default public String getSubDomain() {
        return this.getCurrentErrorCode() == null ? null : this.getCurrentErrorCode().getSubDomain();
    }

    default public String getPayload() {
        return this.getCurrentErrorCode() == null ? null : this.getCurrentErrorCode().getPayload();
    }

    default public String getUrl() {
        return this.getCurrentErrorCode() == null ? null : this.getCurrentErrorCode().getUrl();
    }

    default public boolean isRollbackRequire() {
        return this.getCurrentErrorCode() == null ? false : this.getCurrentErrorCode().isRollbackRequire();
    }

    default public boolean isRetryable() {
        return this.getCurrentErrorCode() == null ? false : this.getCurrentErrorCode().isRetryable();
    }

    default public BiConsumer<String, Exception> getErrorHandler() {
        return this.getCurrentErrorCode() == null ? null : this.getCurrentErrorCode().getErrorHandler();
    }

    default public ErrorCode addDetail(String detail, Object ... values) {
        return this.toBuilder().addMessageDetail(detail, values).build();
    }

    default public String getCategory() {
        return this.getCurrentErrorCode() == null ? null : this.getCurrentErrorCode().getCategory();
    }

    default public String getField() {
        return this.getCurrentErrorCode() == null ? null : this.getCurrentErrorCode().getField();
    }

    default public DefaultErrorCode.DefaultErrorCodeBuilder toBuilder() {
        DefaultErrorCode.DefaultErrorCodeBuilder builder = null;
        builder = this.getCurrentErrorCode() == null ? DefaultErrorCode.fromErrorCode(DefaultErrorCode.buildUndefineError()) : DefaultErrorCode.fromErrorCode(this.getCurrentErrorCode());
        return builder;
    }

    default public Map<String, Serializable> toMap() {
        LinkedHashMap<String, Serializable> result = new LinkedHashMap<String, Serializable>();
        result.put(STATUS_CODE, Integer.valueOf(this.getStatusCode()));
        result.put(ERROR_CODE, (Serializable)((Object)this.getErrorCode()));
        result.put(MESSAGE, (Serializable)((Object)this.getMessage()));
        result.put(MESSAGE_DETAIL, (Serializable)((Object)this.getMessageDetail()));
        result.put(ERROR_TYPE, (Serializable)((Object)this.getErrorType()));
        result.put(PAYLOAD, (Serializable)((Object)this.getPayload()));
        result.put(EXPLOITATION_ERROR, Boolean.valueOf(this.isExploitationError()));
        result.put(ROLLBACK, Boolean.valueOf(this.isRollbackRequire()));
        result.put(RETRYABLE, Boolean.valueOf(this.isRetryable()));
        result.put(FIELD, (Serializable)((Object)this.getField()));
        result.put(URL, (Serializable)((Object)this.getUrl()));
        result.put(CATEGORY, (Serializable)((Object)this.getCategory()));
        result.put(DOMAIN, (Serializable)((Object)this.getDomain()));
        result.put(SUB_DOMAIN, (Serializable)((Object)this.getSubDomain()));
        return result;
    }

    default public List<String> keysSet() {
        return KEYS_SET;
    }
}

