/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions;

import java.text.MessageFormat;
import java.util.regex.Pattern;

public final class MessagesFormatter {
    private static final Pattern REGEX = Pattern.compile("[{][^}]+[}]");
    private static final String NBSP = "\u00a0";

    public static String format(String format, Object ... values) {
        String result = null;
        if (format != null) {
            if (values == null || values.length == 0) {
                result = format;
            } else if (REGEX.matcher(format).find()) {
                MessageFormat formater = new MessageFormat(format.replaceAll("'", "''"));
                result = formater.format(MessagesFormatter.convertToStringArray(values));
            } else {
                result = format;
            }
        }
        return result == null ? null : result.replaceAll(NBSP, " ");
    }

    private static String[] convertToStringArray(Object[] values) {
        String[] result = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = String.valueOf(values[i]);
        }
        return result;
    }

    private MessagesFormatter() {
    }
}

