/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions;

import io.inugami.api.exceptions.DefaultErrorCode;
import io.inugami.api.exceptions.ErrorCode;
import io.inugami.api.exceptions.ExceptionWithErrorCode;
import io.inugami.api.exceptions.MessagesFormatter;

public class UncheckedException
extends RuntimeException
implements ExceptionWithErrorCode {
    private static final long serialVersionUID = 9117748018680221194L;
    private final transient ErrorCode errorCode;

    public UncheckedException() {
        this.errorCode = DefaultErrorCode.buildUndefineError();
    }

    public UncheckedException(ErrorCode errorCode) {
        super(errorCode == null ? "undefined error" : errorCode.getMessage());
        this.errorCode = errorCode;
    }

    public UncheckedException(ErrorCode errorCode, Throwable cause) {
        super(errorCode == null ? DefaultErrorCode.buildUndefineError().getMessage() : errorCode.getMessage(), cause);
        this.errorCode = errorCode == null ? DefaultErrorCode.buildUndefineError() : errorCode;
    }

    public UncheckedException(String message, Throwable cause) {
        this(null, cause, message, null);
    }

    public UncheckedException(String message) {
        this(null, null, message, null);
    }

    public UncheckedException(Throwable cause) {
        this(null, cause, null, null);
    }

    public UncheckedException(String message, Object ... values) {
        this(null, null, message, values);
    }

    public UncheckedException(Throwable cause, String message, Object ... values) {
        this(null, cause, message, values);
    }

    public UncheckedException(ErrorCode errorCode, String message) {
        this(errorCode, null, message, new Object[0]);
    }

    public UncheckedException(ErrorCode errorCode, Throwable cause, String message, Object ... values) {
        super(MessagesFormatter.format(message, values), cause);
        this.errorCode = errorCode == null ? DefaultErrorCode.buildUndefineError() : errorCode;
    }

    @Override
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }
}

