/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.exceptions;

import io.inugami.api.exceptions.DefaultWarning;
import io.inugami.api.functionnals.FunctionalUtils;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Warning {
    public static final String WARNING_CODE = "warningCode";
    public static final String WARNING_MESSAGE = "warningMessage";
    public static final String WARNING_MESSAGE_DETAIL = "warningMessageDetail";
    public static final String WARNING_TYPE = "warningType";
    public static final String WARNING_CATEGORY = "warningCategory";
    public static final String WARNING_DOMAIN = "warningDomain";
    public static final String WARNING_SUB_DOMAIN = "warningSubDomain";
    public static final List<String> KEYS_SET = List.of("warningCode", "warningMessage", "warningMessageDetail", "warningType", "warningCategory", "warningDomain", "warningSubDomain");

    public Warning getCurrentWaring();

    default public String getWarningCode() {
        return this.getCurrentWaring() == null ? "warn" : this.getCurrentWaring().getWarningCode();
    }

    default public String getMessage() {
        return this.getCurrentWaring() == null ? null : this.getCurrentWaring().getMessage();
    }

    default public String getMessageDetail() {
        return this.getCurrentWaring() == null ? null : this.getCurrentWaring().getMessageDetail();
    }

    default public String getWarningType() {
        return this.getCurrentWaring() == null ? "functional" : this.getCurrentWaring().getWarningType();
    }

    default public Warning addDetail(String detail, Object ... values) {
        return this.toBuilder().addMessageDetail(detail, values).build();
    }

    default public String getCategory() {
        return this.getCurrentWaring() == null ? null : this.getCurrentWaring().getCategory();
    }

    default public String getDomain() {
        return this.getCurrentWaring() == null ? null : this.getCurrentWaring().getDomain();
    }

    default public String getSubDomain() {
        return this.getCurrentWaring() == null ? null : this.getCurrentWaring().getSubDomain();
    }

    default public Map<String, Serializable> toMap() {
        LinkedHashMap<String, Serializable> result = new LinkedHashMap<String, Serializable>();
        FunctionalUtils.applyIfNotNull(this.getWarningCode(), value -> result.put(WARNING_CODE, (Serializable)value));
        FunctionalUtils.applyIfNotNull(this.getMessage(), value -> result.put(WARNING_MESSAGE, (Serializable)value));
        FunctionalUtils.applyIfNotNull(this.getMessageDetail(), value -> result.put(WARNING_MESSAGE_DETAIL, (Serializable)value));
        FunctionalUtils.applyIfNotNull(this.getWarningType(), value -> result.put(WARNING_TYPE, (Serializable)value));
        FunctionalUtils.applyIfNotNull(this.getCategory(), value -> result.put(WARNING_CATEGORY, (Serializable)value));
        FunctionalUtils.applyIfNotNull(this.getDomain(), value -> result.put(WARNING_DOMAIN, (Serializable)value));
        FunctionalUtils.applyIfNotNull(this.getSubDomain(), value -> result.put(WARNING_SUB_DOMAIN, (Serializable)value));
        return result;
    }

    default public List<String> keysSet() {
        return KEYS_SET;
    }

    default public DefaultWarning.DefaultWarningBuilder toBuilder() {
        DefaultWarning.DefaultWarningBuilder builder = null;
        builder = this.getCurrentWaring() == null ? DefaultWarning.builder() : DefaultWarning.fromWarningCode(this.getCurrentWaring());
        return builder;
    }
}

