/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.functionnals;

import io.inugami.api.functionnals.VoidFunction;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.function.Supplier;

public final class FunctionalUtils {
    public static <T> boolean applyIfNotNull(T data, Consumer<T> consumer) {
        if (data != null) {
            consumer.accept(data);
            return true;
        }
        return false;
    }

    public static <T> boolean applyIfNotNull(T data, T defaultValue, Consumer<T> consumer) {
        return FunctionalUtils.applyIfNotNull(data == null ? defaultValue : data, consumer);
    }

    public static <T> void processIfNull(T object, VoidFunction supplier) {
        if (object == null) {
            supplier.process();
        }
    }

    public static <T> void processIfNotNull(T object, VoidFunction supplier) {
        if (object != null) {
            supplier.process();
        }
    }

    public static <T> void processIfNotNull(T object, Consumer<T> supplier) {
        if (object != null) {
            supplier.accept(object);
        }
    }

    public static <T> T applyIfNull(T data, Supplier<T> supplier) {
        return data == null ? supplier.get() : data;
    }

    public static <T extends Collection<?>> T applyIfEmpty(T data, Supplier<T> supplier) {
        return (T)(data == null || data.isEmpty() ? (Collection)supplier.get() : data);
    }

    public static <T extends Map<?, ?>> T applyIfEmpty(T data, Supplier<T> supplier) {
        return (T)(data == null || data.isEmpty() ? (Map)supplier.get() : data);
    }

    public static String applyIfEmpty(String data, Supplier<String> supplier) {
        return data == null || data.trim().isEmpty() ? supplier.get() : data;
    }

    public static String orNull(String data) {
        return data == null || data.trim().isEmpty() ? null : data;
    }

    public static <T extends Collection<?>> T applyIfNotEmpty(T data, Supplier<T> supplier) {
        return (T)(data != null && !data.isEmpty() ? (Collection)supplier.get() : data);
    }

    public static <T extends Map<?, ?>> T applyIfNotEmpty(T data, Supplier<T> supplier) {
        return (T)(data != null && !data.isEmpty() ? (Map)supplier.get() : data);
    }

    public static String applyIfNotEmpty(String data, Supplier<String> supplier) {
        return data != null && !data.trim().isEmpty() ? supplier.get() : data;
    }

    public static boolean applyIfChange(boolean ref, boolean newValue, Consumer<Boolean> consumer) {
        if (ref != newValue) {
            consumer.accept(newValue);
            return true;
        }
        return false;
    }

    public static boolean applyIfChange(short ref, short newValue, Consumer<Short> consumer) {
        if (ref != newValue) {
            consumer.accept(newValue);
            return true;
        }
        return false;
    }

    public static boolean applyIfChange(int ref, int newValue, IntConsumer consumer) {
        if (ref != newValue) {
            consumer.accept(newValue);
            return true;
        }
        return false;
    }

    public static boolean applyIfChange(float ref, float newValue, Consumer<Float> consumer) {
        if (ref != newValue) {
            consumer.accept(Float.valueOf(newValue));
            return true;
        }
        return false;
    }

    public static boolean applyIfChange(long ref, long newValue, LongConsumer consumer) {
        if (ref != newValue) {
            consumer.accept(newValue);
            return true;
        }
        return false;
    }

    public static boolean applyIfChange(double ref, double newValue, DoubleConsumer consumer) {
        if (ref != newValue) {
            consumer.accept(newValue);
            return true;
        }
        return false;
    }

    public static <T> boolean applyIfChange(T ref, T newValue, Consumer<T> consumer) {
        if (FunctionalUtils.hasChange(ref, newValue)) {
            consumer.accept(newValue);
            return true;
        }
        return false;
    }

    public static <T> boolean applyIfChangeAndNotNull(T ref, T newValue, Consumer<T> consumer) {
        if (FunctionalUtils.hasChange(ref, newValue)) {
            return FunctionalUtils.applyIfNotNull(newValue, consumer);
        }
        return false;
    }

    protected static <T> boolean hasChange(T ref, T newValue) {
        if (ref == null && newValue == null) {
            return false;
        }
        if (ref == null || newValue == null) {
            return true;
        }
        return !ref.equals(newValue);
    }

    private FunctionalUtils() {
    }
}

