/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.models.tools;

import java.io.Serializable;

public final class Chrono
implements Serializable {
    private static final long serialVersionUID = 1317921298017444143L;
    private static final long UNDEF = -1L;
    private long startTime;
    private long startTimeMs;
    private long stopTime;
    private long stopTimeMs;
    private boolean running = false;

    public Chrono() {
        this(-1L, -1L);
    }

    protected Chrono(long startTime, long stopTime) {
        this.startTime = startTime;
        this.stopTime = stopTime;
    }

    public static Chrono startChrono() {
        return new Chrono().start();
    }

    public Chrono start() {
        this.startTime = System.nanoTime();
        this.startTimeMs = System.currentTimeMillis();
        this.running = true;
        return this;
    }

    public Chrono stop() {
        this.stopTime = System.nanoTime();
        this.stopTimeMs = System.currentTimeMillis();
        this.running = false;
        return this;
    }

    public Chrono snapshot() {
        if (this.running) {
            this.stopTime = System.nanoTime();
        }
        return this;
    }

    public Chrono cloneObj() {
        return new Chrono(this.startTime, this.startTimeMs, this.stopTime, this.stopTimeMs, this.running);
    }

    public long getDuration() {
        return this.getDurationNano() / 1000000L;
    }

    public long getDurationNano() {
        return this.stopTime == -1L ? -1L : this.stopTime - this.startTime;
    }

    public Chrono(long startTime, long startTimeMs, long stopTime, long stopTimeMs, boolean running) {
        this.startTime = startTime;
        this.startTimeMs = startTimeMs;
        this.stopTime = stopTime;
        this.stopTimeMs = stopTimeMs;
        this.running = running;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chrono)) {
            return false;
        }
        Chrono other = (Chrono)o;
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        return this.getStopTimeMs() == other.getStopTimeMs();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $stopTimeMs = this.getStopTimeMs();
        result = result * 59 + (int)($stopTimeMs >>> 32 ^ $stopTimeMs);
        return result;
    }

    public String toString() {
        return "Chrono(startTime=" + this.getStartTime() + ", startTimeMs=" + this.getStartTimeMs() + ", stopTime=" + this.getStopTime() + ", stopTimeMs=" + this.getStopTimeMs() + ", running=" + this.isRunning() + ")";
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public long getStopTimeMs() {
        return this.stopTimeMs;
    }

    public boolean isRunning() {
        return this.running;
    }
}

