/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.monitoring.data;

import io.inugami.api.models.ClonableObject;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResponseData
implements Serializable,
ClonableObject<ResponseData> {
    private static final long serialVersionUID = 2949186095649126700L;
    private final long duration;
    private final long datetime;
    private final int code;
    private final String content;
    private final String contentType;
    private Map<String, String> hearder;
    private final transient HttpServletRequest httpRequest;
    private final transient HttpServletResponse httpResponse;

    @Override
    public ResponseData cloneObj() {
        return this.toBuilder().build();
    }

    public static ResponseDataBuilder builder() {
        return new ResponseDataBuilder();
    }

    public ResponseDataBuilder toBuilder() {
        return new ResponseDataBuilder().duration(this.duration).datetime(this.datetime).code(this.code).content(this.content).contentType(this.contentType).hearder(this.hearder).httpRequest(this.httpRequest).httpResponse(this.httpResponse);
    }

    public ResponseData(long duration, long datetime, int code, String content, String contentType, Map<String, String> hearder, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.duration = duration;
        this.datetime = datetime;
        this.code = code;
        this.content = content;
        this.contentType = contentType;
        this.hearder = hearder;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
    }

    public String toString() {
        return "ResponseData(code=" + this.getCode() + ", contentType=" + this.getContentType() + ")";
    }

    public long getDuration() {
        return this.duration;
    }

    public long getDatetime() {
        return this.datetime;
    }

    public int getCode() {
        return this.code;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, String> getHearder() {
        return this.hearder;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public static class ResponseDataBuilder {
        private long duration;
        private long datetime;
        private int code;
        private String content;
        private String contentType;
        private Map<String, String> hearder;
        private HttpServletRequest httpRequest;
        private HttpServletResponse httpResponse;

        public ResponseDataBuilder addHeader(String key, String value) {
            if (this.hearder == null) {
                this.hearder = new LinkedHashMap<String, String>();
            }
            if (key != null && value != null) {
                this.hearder.put(key, value);
            }
            return this;
        }

        ResponseDataBuilder() {
        }

        public ResponseDataBuilder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public ResponseDataBuilder datetime(long datetime) {
            this.datetime = datetime;
            return this;
        }

        public ResponseDataBuilder code(int code) {
            this.code = code;
            return this;
        }

        public ResponseDataBuilder content(String content) {
            this.content = content;
            return this;
        }

        public ResponseDataBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public ResponseDataBuilder hearder(Map<String, String> hearder) {
            this.hearder = hearder;
            return this;
        }

        public ResponseDataBuilder httpRequest(HttpServletRequest httpRequest) {
            this.httpRequest = httpRequest;
            return this;
        }

        public ResponseDataBuilder httpResponse(HttpServletResponse httpResponse) {
            this.httpResponse = httpResponse;
            return this;
        }

        public ResponseData build() {
            return new ResponseData(this.duration, this.datetime, this.code, this.content, this.contentType, this.hearder, this.httpRequest, this.httpResponse);
        }

        public String toString() {
            return "ResponseData.ResponseDataBuilder(duration=" + this.duration + ", datetime=" + this.datetime + ", code=" + this.code + ", content=" + this.content + ", contentType=" + this.contentType + ", hearder=" + this.hearder + ", httpRequest=" + this.httpRequest + ", httpResponse=" + this.httpResponse + ")";
        }
    }
}

