/*
 * Decompiled with CFR 0.152.
 */
package io.inugami.api.tools;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringTools {
    private static final Pattern IN_COMBINING_DIACRITICAL_MARKS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}]");
    private static final List<UnaryOperator<String>> STARTEGIES = StringTools.initializeStrategies();

    private static List<UnaryOperator<String>> initializeStrategies() {
        ArrayList<UnaryOperator<String>> result = new ArrayList<UnaryOperator<String>>();
        result.add(value -> StringTools.containsChars(value, "\u0141") ? value.replaceAll("\u0141", "L") : value);
        result.add(value -> StringTools.containsChars(value, "\u0142") ? value.replaceAll("\u0142", "l") : value);
        result.add(value -> StringTools.containsChars(value, "\u00d8") ? value.replaceAll("\u00d8", "O") : value);
        result.add(value -> StringTools.containsChars(value, "\u00f8") ? value.replaceAll("\u00f8", "o") : value);
        result.add(value -> StringTools.containsChars(value, "\u0152") ? value.replaceAll("\u0152", "OE") : value);
        result.add(value -> StringTools.containsChars(value, "\u0153") ? value.replaceAll("\u0153", "oe") : value);
        result.add(value -> StringTools.containsChars(value, "\u00c6") ? value.replaceAll("\u00c6", "AE") : value);
        result.add(value -> StringTools.containsChars(value, "\u00e6") ? value.replaceAll("\u00e6", "ae") : value);
        result.add(value -> StringTools.containsChars(value, "\u00df") ? value.replaceAll("\u00df", "ss") : value);
        result.add(value -> StringTools.containsChars(value, "\u1e9e") ? value.replaceAll("\u1e9e", "SS") : value);
        return result;
    }

    public static String replaceAll(Pattern regex, String data, String replacement) {
        String result = data;
        Matcher matcher = regex.matcher(data);
        if (matcher.find()) {
            result = matcher.replaceAll(replacement);
        }
        return result;
    }

    public static String convertToAscii(String value) {
        if (value == null) {
            return null;
        }
        String firstPass = StringTools.replaceAll(IN_COMBINING_DIACRITICAL_MARKS, Normalizer.normalize(value, Normalizer.Form.NFD), "");
        return StringTools.cleanSpecialChars(firstPass);
    }

    private static String cleanSpecialChars(String value) {
        String result = value;
        for (UnaryOperator<String> cleaner : STARTEGIES) {
            result = (String)cleaner.apply(result);
        }
        return result;
    }

    public static boolean containsChars(String value, String specialChar) {
        return value == null ? false : value.contains(specialChar);
    }

    private StringTools() {
    }
}

