/*
 * Decompiled with CFR 0.152.
 */
package io.iteratee.files;

import cats.Applicative;
import cats.Monad;
import cats.MonadError;
import cats.effect.Sync;
import io.iteratee.Enumerator;
import io.iteratee.Enumerator$;
import io.iteratee.Iteratee;
import io.iteratee.Iteratee$;
import io.iteratee.files.package;
import io.iteratee.files.package$ByteEnumerator$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class package$ {
    public static package$ MODULE$;

    static {
        new package$();
    }

    public <F> Enumerator<F, String> readLines(File file, Sync<F> F) {
        return this.enumerateLines((Function0<BufferedReader>)(Function0 & Serializable & scala.Serializable)() -> new BufferedReader(new FileReader(file)), F);
    }

    public <F> Enumerator<F, String> readLinesFromStream(InputStream stream, Sync<F> F) {
        return this.enumerateLines((Function0<BufferedReader>)(Function0 & Serializable & scala.Serializable)() -> new BufferedReader(new InputStreamReader(stream)), F);
    }

    public <F> Enumerator<F, byte[]> readBytes(File file, Sync<F> F) {
        return this.enumerateBytes((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> new BufferedInputStream(new FileInputStream(file)), F);
    }

    public <F> Enumerator<F, byte[]> readBytesFromStream(InputStream stream, Sync<F> F) {
        return this.enumerateBytes((Function0<InputStream>)(Function0 & Serializable & scala.Serializable)() -> new BufferedInputStream(stream), F);
    }

    public <F> Enumerator<F, Tuple2<ZipEntry, InputStream>> readZipStreams(File file, Sync<F> F) {
        return Enumerator$.MODULE$.liftM(F.delay((Function0 & Serializable & scala.Serializable)() -> new ZipFile(file)), F).flatMap((Function1 & Serializable & scala.Serializable)zipFile -> new package.ZipFileEnumerator((ZipFile)zipFile, (Iterator<ZipEntry>)((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(zipFile.entries()).asScala()), F).ensure(F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> zipFile.close()), (MonadError)F), F);
    }

    public <F> Enumerator<F, File> listFiles(File dir, Sync<F> F) {
        return Enumerator$.MODULE$.liftM(F.delay((Function0 & Serializable & scala.Serializable)() -> dir.listFiles()), F).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            File[] fileArray = x0$1;
            Enumerator enumerator = fileArray == null ? Enumerator$.MODULE$.empty((Applicative)F) : Enumerator$.MODULE$.enumVector(Predef$.MODULE$.genericArrayOps((Object)fileArray).toVector(), (Applicative)F);
            return enumerator;
        }, F);
    }

    public <F> Enumerator<F, File> listFilesRec(File dir, Sync<F> F) {
        return this.listFiles(dir, F).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            File file = x0$2;
            Enumerator enumerator = file.isDirectory() ? MODULE$.listFilesRec(file, F) : Enumerator$.MODULE$.enumOne((Object)file, (Applicative)F);
            return enumerator;
        }, F);
    }

    public <F> Iteratee<F, String, BoxedUnit> writeLines(File file, Sync<F> F) {
        return Iteratee$.MODULE$.liftM(F.delay((Function0 & Serializable & scala.Serializable)() -> new BufferedWriter(new FileWriter(file))), F).flatMap((Function1 & Serializable & scala.Serializable)writer -> Iteratee$.MODULE$.foldM((Object)BoxedUnit.UNIT, (Function2 & Serializable & scala.Serializable)(x$1, line) -> F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            writer.write((String)line);
            writer.newLine();
        }), (Monad)F).ensure(F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close()), (MonadError)F), F);
    }

    public <F> Iteratee<F, String, BoxedUnit> writeLinesToStream(OutputStream stream, Sync<F> F) {
        return Iteratee$.MODULE$.liftM(F.delay((Function0 & Serializable & scala.Serializable)() -> new BufferedWriter(new OutputStreamWriter(stream))), F).flatMap((Function1 & Serializable & scala.Serializable)writer -> Iteratee$.MODULE$.foldM((Object)BoxedUnit.UNIT, (Function2 & Serializable & scala.Serializable)(x$2, line) -> F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            writer.write((String)line);
            writer.newLine();
        }), (Monad)F).ensure(F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close()), (MonadError)F), F);
    }

    public <F> Iteratee<F, byte[], BoxedUnit> writeBytes(File file, Sync<F> F) {
        return Iteratee$.MODULE$.liftM(F.delay((Function0 & Serializable & scala.Serializable)() -> new BufferedOutputStream(new FileOutputStream(file))), F).flatMap((Function1 & Serializable & scala.Serializable)stream -> Iteratee$.MODULE$.foldM((Object)BoxedUnit.UNIT, (Function2 & Serializable & scala.Serializable)(x$3, bytes) -> F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> stream.write((byte[])bytes)), (Monad)F).ensure(F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> stream.close()), (MonadError)F), F);
    }

    public <F> Iteratee<F, byte[], BoxedUnit> writeBytesToStream(OutputStream stream2, Sync<F> F) {
        return Iteratee$.MODULE$.liftM(F.delay((Function0 & Serializable & scala.Serializable)() -> new BufferedOutputStream(stream2)), F).flatMap((Function1 & Serializable & scala.Serializable)stream -> Iteratee$.MODULE$.foldM((Object)BoxedUnit.UNIT, (Function2 & Serializable & scala.Serializable)(x$4, bytes) -> F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> stream.write((byte[])bytes)), (Monad)F).ensure(F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> stream.close()), (MonadError)F), F);
    }

    private <F> Enumerator<F, String> enumerateLines(Function0<BufferedReader> reader2, Sync<F> F) {
        return Enumerator$.MODULE$.liftM(F.delay(reader2), F).flatMap((Function1 & Serializable & scala.Serializable)reader -> new package.LineEnumerator((BufferedReader)reader, F).ensure(F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close()), (MonadError)F), F);
    }

    private <F> Enumerator<F, byte[]> enumerateBytes(Function0<InputStream> stream, Sync<F> F) {
        return Enumerator$.MODULE$.liftM(F.delay(stream), F).flatMap((Function1 & Serializable & scala.Serializable)reader -> new package.ByteEnumerator((InputStream)stream.apply(), package$ByteEnumerator$.MODULE$.$lessinit$greater$default$2(), F).ensure(F.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((InputStream)stream.apply()).close()), (MonadError)F), F);
    }

    private package$() {
        MODULE$ = this;
    }
}

