/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing;

import io.jaegertracing.exceptions.EmptyTracerStateStringException;
import io.jaegertracing.exceptions.MalformedTracerStateStringException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SpanContext
implements io.opentracing.SpanContext {
    protected static final byte flagSampled = 1;
    protected static final byte flagDebug = 2;
    private final long traceId;
    private final long spanId;
    private final long parentId;
    private final byte flags;
    private final Map<String, String> baggage;
    private final String debugId;

    public SpanContext(long traceId, long spanId, long parentId, byte flags) {
        this(traceId, spanId, parentId, flags, Collections.emptyMap(), null);
    }

    SpanContext(long traceId, long spanId, long parentId, byte flags, Map<String, String> baggage, String debugId) {
        if (baggage == null) {
            throw new NullPointerException();
        }
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.flags = flags;
        this.baggage = baggage;
        this.debugId = debugId;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return new HashMap<String, String>(this.baggage).entrySet();
    }

    public String getBaggageItem(String key) {
        return this.baggage.get(key);
    }

    Map<String, String> baggage() {
        return this.baggage;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isSampled() {
        return (this.flags & 1) == 1;
    }

    public boolean isDebug() {
        return (this.flags & 2) == 2;
    }

    public String contextAsString() {
        int intFlag = this.flags & 0xFF;
        return Long.toHexString(this.traceId) + ":" + Long.toHexString(this.spanId) + ":" + Long.toHexString(this.parentId) + ":" + Integer.toHexString(intFlag);
    }

    public String toString() {
        return this.contextAsString();
    }

    public static SpanContext contextFromString(String value) throws MalformedTracerStateStringException, EmptyTracerStateStringException {
        if (value == null || value.equals("")) {
            throw new EmptyTracerStateStringException();
        }
        String[] parts = value.split(":");
        if (parts.length != 4) {
            throw new MalformedTracerStateStringException(value);
        }
        return new SpanContext(new BigInteger(parts[0], 16).longValue(), new BigInteger(parts[1], 16).longValue(), new BigInteger(parts[2], 16).longValue(), new BigInteger(parts[3], 16).byteValue());
    }

    public SpanContext withBaggageItem(String key, String val) {
        HashMap<String, String> newBaggage = new HashMap<String, String>(this.baggage);
        if (val == null) {
            newBaggage.remove(key);
        } else {
            newBaggage.put(key, val);
        }
        return new SpanContext(this.traceId, this.spanId, this.parentId, this.flags, newBaggage, this.debugId);
    }

    public SpanContext withBaggage(Map<String, String> newBaggage) {
        return new SpanContext(this.traceId, this.spanId, this.parentId, this.flags, newBaggage, this.debugId);
    }

    public SpanContext withFlags(byte flags) {
        return new SpanContext(this.traceId, this.spanId, this.parentId, flags, this.baggage, this.debugId);
    }

    boolean isDebugIdContainerOnly() {
        return this.traceId == 0L && this.debugId != null;
    }

    public static SpanContext withDebugId(String debugId) {
        return new SpanContext(0L, 0L, 0L, 0, Collections.<String, String>emptyMap(), debugId);
    }

    String getDebugId() {
        return this.debugId;
    }
}

