/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.metrics;

import io.jaegertracing.metrics.Counter;
import io.jaegertracing.metrics.Gauge;
import io.jaegertracing.metrics.Metric;
import io.jaegertracing.metrics.MetricsFactory;
import io.jaegertracing.metrics.Tag;
import io.jaegertracing.metrics.Timer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class Metrics {
    @Metric(name="traces", tags={@Tag(key="state", value="started"), @Tag(key="sampled", value="y")})
    public Counter traceStartedSampled;
    @Metric(name="traces", tags={@Tag(key="state", value="started"), @Tag(key="sampled", value="n")})
    public Counter traceStartedNotSampled;
    @Metric(name="traces", tags={@Tag(key="state", value="joined"), @Tag(key="sampled", value="y")})
    public Counter tracesJoinedSampled;
    @Metric(name="traces", tags={@Tag(key="state", value="joined"), @Tag(key="sampled", value="n")})
    public Counter tracesJoinedNotSampled;
    @Metric(name="started_spans", tags={@Tag(key="sampled", value="y")})
    public Counter spansStartedSampled;
    @Metric(name="started_spans", tags={@Tag(key="sampled", value="n")})
    public Counter spansStartedNotSampled;
    @Metric(name="finished_spans")
    public Counter spansFinished;
    @Metric(name="span_context_decoding_errors")
    public Counter decodingErrors;
    @Metric(name="reporter_spans", tags={@Tag(key="result", value="ok")})
    public Counter reporterSuccess;
    @Metric(name="reporter_spans", tags={@Tag(key="result", value="err")})
    public Counter reporterFailure;
    @Metric(name="reporter_spans", tags={@Tag(key="result", value="dropped")})
    public Counter reporterDropped;
    @Metric(name="reporter_queue_length")
    public Gauge reporterQueueLength;
    @Metric(name="sampler_queries", tags={@Tag(key="result", value="ok")})
    public Counter samplerRetrieved;
    @Metric(name="sampler_queries", tags={@Tag(key="result", value="err")})
    public Counter samplerQueryFailure;
    @Metric(name="sampler_updates", tags={@Tag(key="result", value="ok")})
    public Counter samplerUpdated;
    @Metric(name="sampler_updates", tags={@Tag(key="result", value="err")})
    public Counter samplerParsingFailure;
    @Metric(name="baggage_updates", tags={@Tag(key="result", value="ok")})
    public Counter baggageUpdateSuccess;
    @Metric(name="baggage_updates", tags={@Tag(key="result", value="err")})
    public Counter baggageUpdateFailure;
    @Metric(name="baggage_truncations")
    public Counter baggageTruncate;
    @Metric(name="baggage_restrictions_updates", tags={@Tag(key="result", value="ok")})
    public Counter baggageRestrictionsUpdateSuccess;
    @Metric(name="baggage_restrictions_updates", tags={@Tag(key="result", value="err")})
    public Counter baggageRestrictionsUpdateFailure;

    public Metrics(MetricsFactory factory) {
        this.createMetrics(factory);
    }

    private void createMetrics(MetricsFactory factory) {
        for (Field field : Metrics.class.getDeclaredFields()) {
            Annotation[] annotations;
            if (!Counter.class.isAssignableFrom(field.getType()) && !Timer.class.isAssignableFrom(field.getType()) && !Gauge.class.isAssignableFrom(field.getType())) continue;
            StringBuilder metricBuilder = new StringBuilder("jaeger:");
            HashMap<String, String> tags = new HashMap<String, String>();
            for (Annotation anno : annotations = field.getAnnotations()) {
                Tag[] entries;
                if (!anno.annotationType().equals(Metric.class)) continue;
                Metric metricAnno = (Metric)anno;
                metricBuilder.append(metricAnno.name());
                for (Tag t : entries = metricAnno.tags()) {
                    tags.put(t.key(), t.value());
                }
            }
            String metricName = metricBuilder.toString();
            try {
                if (field.getType().equals(Counter.class)) {
                    field.set(this, factory.createCounter(metricName, tags));
                    continue;
                }
                if (field.getType().equals(Gauge.class)) {
                    field.set(this, factory.createGauge(metricName, tags));
                    continue;
                }
                if (field.getType().equals(Timer.class)) {
                    field.set(this, factory.createTimer(metricName, tags));
                    continue;
                }
                throw new RuntimeException("A field type that was neither Counter, Gauge, or Timer was parsed in reflection.");
            }
            catch (Exception e) {
                throw new RuntimeException("No reflection exceptions should be thrown unless there is a fundamental error in your code set up.", e);
            }
        }
    }

    public static String addTagsToMetricName(String name, Map<String, String> tags) {
        if (tags == null || tags.size() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        TreeMap<String, String> sortedTags = new TreeMap<String, String>(tags);
        for (Map.Entry entry : sortedTags.entrySet()) {
            sb.append(".");
            sb.append((String)entry.getKey());
            sb.append("=");
            sb.append((String)entry.getValue());
        }
        return sb.toString();
    }
}

