/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.propagation;

import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.propagation.PrefixedKeys;
import io.jaegertracing.spi.Codec;
import io.opentracing.propagation.TextMap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TextMapCodec
implements Codec<TextMap> {
    private static final String SPAN_CONTEXT_KEY = "uber-trace-id";
    private static final String BAGGAGE_KEY_PREFIX = "uberctx-";
    private static final PrefixedKeys keys = new PrefixedKeys();
    private final String contextKey;
    private final String baggagePrefix;
    private final boolean urlEncoding;

    public TextMapCodec(boolean urlEncoding) {
        this(TextMapCodec.builder().withUrlEncoding(urlEncoding));
    }

    private TextMapCodec(Builder builder) {
        this.urlEncoding = builder.urlEncoding;
        this.contextKey = builder.spanContextKey;
        this.baggagePrefix = builder.baggagePrefix;
    }

    @Override
    public void inject(JaegerSpanContext spanContext, TextMap carrier) {
        carrier.put(this.contextKey, this.encodedValue(spanContext.contextAsString()));
        for (Map.Entry<String, String> entry : spanContext.baggageItems()) {
            carrier.put(keys.prefixedKey(entry.getKey(), this.baggagePrefix), this.encodedValue(entry.getValue()));
        }
    }

    @Override
    public JaegerSpanContext extract(TextMap carrier) {
        JaegerSpanContext context = null;
        HashMap<String, String> baggage = null;
        String debugId = null;
        for (Map.Entry entry : carrier) {
            String key = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
            if (key.equals(this.contextKey)) {
                context = JaegerSpanContext.contextFromString(this.decodedValue((String)entry.getValue()));
                continue;
            }
            if (key.equals("jaeger-debug-id")) {
                debugId = this.decodedValue((String)entry.getValue());
                continue;
            }
            if (!key.startsWith(this.baggagePrefix)) continue;
            if (baggage == null) {
                baggage = new HashMap<String, String>();
            }
            baggage.put(keys.unprefixedKey(key, this.baggagePrefix), this.decodedValue((String)entry.getValue()));
        }
        if (context == null) {
            if (debugId != null) {
                return JaegerSpanContext.withDebugId(debugId);
            }
            return null;
        }
        if (baggage == null) {
            return context;
        }
        return context.withBaggage(baggage);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TextMapCodec{").append("contextKey=").append(this.contextKey).append(',').append("baggagePrefix=").append(this.baggagePrefix).append(',').append("urlEncoding=").append(this.urlEncoding).append('}');
        return buffer.toString();
    }

    private String encodedValue(String value) {
        if (!this.urlEncoding) {
            return value;
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    private String decodedValue(String value) {
        if (!this.urlEncoding) {
            return value;
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean urlEncoding;
        private String spanContextKey = "uber-trace-id";
        private String baggagePrefix = "uberctx-";

        public Builder withUrlEncoding(boolean urlEncoding) {
            this.urlEncoding = urlEncoding;
            return this;
        }

        public Builder withSpanContextKey(String spanContextKey) {
            this.spanContextKey = spanContextKey;
            return this;
        }

        public Builder withBaggagePrefix(String baggagePrefix) {
            this.baggagePrefix = baggagePrefix;
            return this;
        }

        public TextMapCodec build() {
            return new TextMapCodec(this);
        }
    }
}

