/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.clock;

import io.jaegertracing.internal.clock.Clock;
import io.jaegertracing.internal.clock.MicrosAccurateClock;
import io.jaegertracing.internal.clock.MillisAccurrateClock;

public class SystemClock
implements Clock {
    private static final Clock DELEGATE;

    private static int getJavaVersion() {
        String[] sections = System.getProperty("java.version").split("\\.");
        int major = Integer.parseInt(sections[0]);
        return major == 1 ? Integer.parseInt(sections[1]) : major;
    }

    @Override
    public long currentTimeMicros() {
        return DELEGATE.currentTimeMicros();
    }

    @Override
    public long currentNanoTicks() {
        return DELEGATE.currentNanoTicks();
    }

    @Override
    public boolean isMicrosAccurate() {
        return DELEGATE.isMicrosAccurate();
    }

    static {
        int version = SystemClock.getJavaVersion();
        DELEGATE = version >= 9 ? MicrosAccurateClock.INSTANCE : MillisAccurrateClock.INSTANCE;
    }
}

