/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.crossdock;

import io.jaegertracing.Configuration;
import io.jaegertracing.crossdock.resources.behavior.EndToEndBehavior;
import io.jaegertracing.crossdock.resources.behavior.ExceptionMapper;
import io.jaegertracing.crossdock.resources.behavior.http.EndToEndBehaviorResource;
import io.jaegertracing.crossdock.resources.behavior.http.TraceBehaviorResource;
import io.jaegertracing.crossdock.resources.health.HealthResource;
import io.jaegertracing.spi.Sender;
import io.jaegertracing.thrift.internal.senders.HttpSender;
import io.jaegertracing.thrift.internal.senders.UdpSender;
import io.opentracing.Tracer;
import io.opentracing.contrib.jaxrs2.client.ClientTracingFeature;
import io.opentracing.contrib.jaxrs2.server.ServerTracingDynamicFeature;
import io.opentracing.contrib.jaxrs2.server.SpanFinishingFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import org.apache.log4j.BasicConfigurator;
import org.apache.thrift.transport.TTransportException;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.jersey.filter.LoggingFilter;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class JerseyServer {
    private static final String SAMPLING_HOST_PORT = "SAMPLING_HOST_PORT";
    private static final String AGENT_HOST = "AGENT_HOST";
    private static final String COLLECTOR_HOST_PORT = "COLLECTOR_HOST_PORT";
    public static Client client;
    private final HttpServer server;
    private final Configuration config;

    public JerseyServer(String host, int port, Configuration configuration, List<Object> resources) throws IOException {
        this.config = configuration;
        ResourceConfig rc = new ResourceConfig();
        resources.forEach(arg_0 -> ((ResourceConfig)rc).register(arg_0));
        rc.register((Object)new ServerTracingDynamicFeature.Builder((Tracer)this.config.getTracer()).withTraceSerialization(false).build()).register(LoggingFilter.class).register(ExceptionMapper.class).register(JacksonFeature.class);
        WebappContext context = new WebappContext("grizzly web context", "");
        context.addServlet("jaxrs", (Servlet)new ServletContainer(rc)).addMapping(new String[]{"/", "/*"});
        context.addFilter("tracingFilter", (Filter)new SpanFinishingFilter()).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), new String[]{"/*"});
        this.server = HttpServer.createSimpleServer((String)".", (String)host, (int)port);
        context.deploy(this.server);
        client = JerseyServer.initializeClient(this.config);
        this.server.start();
    }

    public void addNetworkListener(NetworkListener networkListener) {
        this.server.addListener(networkListener);
    }

    private static Client initializeClient(Configuration config) {
        return (Client)((Client)((Client)ClientBuilder.newClient().register(ExceptionMapper.class)).register((Object)new ClientTracingFeature.Builder((Tracer)config.getTracer()).build())).register(JacksonFeature.class);
    }

    public void shutdown() throws ExecutionException, InterruptedException {
        this.server.shutdownNow();
        for (NetworkListener next : this.server.getListeners()) {
            GrizzlyFuture grizzlyFuture = next.shutdown();
        }
    }

    public Tracer getTracer() {
        return this.config.getTracer();
    }

    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        String serviceName = JerseyServer.serviceNameFromEnv();
        Configuration configuration = new Configuration(serviceName).withSampler(new Configuration.SamplerConfiguration().withType("const").withParam((Number)0)).withReporter(new Configuration.ReporterConfiguration().withLogSpans(Boolean.valueOf(true)));
        JerseyServer server = new JerseyServer("0.0.0.0", 8081, configuration, Arrays.asList(new TraceBehaviorResource((Tracer)configuration.getTracer()), new EndToEndBehaviorResource(new EndToEndBehavior(JerseyServer.getEvn(SAMPLING_HOST_PORT, "jaeger-agent:5778"), "crossdock-" + serviceName, JerseyServer.senderFromEnv(JerseyServer.getEvn(COLLECTOR_HOST_PORT, "jaeger-collector:14268"), JerseyServer.getEvn(AGENT_HOST, "jaeger-agent")))), new HealthResource()));
        server.addNetworkListener(new NetworkListener("health", "0.0.0.0", 8080));
        Thread.currentThread().join();
    }

    private static String getEvn(String envName, String defaultValue) {
        String env = System.getenv(envName);
        if (env == null) {
            return defaultValue;
        }
        return env;
    }

    private static Sender senderFromEnv(String collectorHostPort, String agentHost) throws TTransportException {
        String senderEnvVar = System.getenv("SENDER");
        if ("http".equalsIgnoreCase(senderEnvVar)) {
            return new HttpSender.Builder(String.format("http://%s/api/traces", collectorHostPort)).build();
        }
        if ("udp".equalsIgnoreCase(senderEnvVar) || senderEnvVar == null || senderEnvVar.isEmpty()) {
            return new UdpSender(agentHost, 0, 0);
        }
        throw new IllegalStateException("Env variable SENDER, is not valid, choose 'udp' or 'http'");
    }

    private static String serviceNameFromEnv() {
        String senderEnvVar = System.getenv("SENDER");
        if (senderEnvVar == null || senderEnvVar.isEmpty()) {
            return "java";
        }
        return "java-" + senderEnvVar;
    }
}

