/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.crossdock.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.jaegertracing.crossdock.thrift.Transport;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Downstream {
    private String serviceName;
    private String host;
    private String port;
    private String transport;
    private String serverRole;
    private Downstream downstream;

    @JsonCreator
    public Downstream(@JsonProperty(value="serviceName") String serviceName, @JsonProperty(value="host") String host, @JsonProperty(value="port") String port, @JsonProperty(value="transport") String transport, @JsonProperty(value="serverRole") String serverRole, @JsonProperty(value="downstream") Downstream downstream) {
        this.serviceName = serviceName;
        this.host = host;
        this.port = port;
        this.transport = transport;
        this.serverRole = serverRole;
        this.downstream = downstream;
    }

    public static Downstream fromThrift(io.jaegertracing.crossdock.thrift.Downstream downstream) {
        if (downstream == null) {
            return null;
        }
        return new Downstream(downstream.getServiceName(), downstream.getHost(), downstream.getPort(), Downstream.fromThrift(downstream.getTransport()), downstream.getServerRole(), Downstream.fromThrift(downstream.getDownstream()));
    }

    private static String fromThrift(Transport transport) {
        switch (transport) {
            case HTTP: {
                return "HTTP";
            }
        }
        throw new IllegalArgumentException("Unknown transport " + transport);
    }

    public static io.jaegertracing.crossdock.thrift.Downstream toThrift(Downstream downstream) {
        if (downstream == null) {
            return null;
        }
        return new io.jaegertracing.crossdock.thrift.Downstream(downstream.getServiceName(), downstream.getServerRole(), downstream.getHost(), downstream.getPort(), Downstream.toThrift(downstream.getTransport()));
    }

    private static Transport toThrift(String transport) {
        if ("HTTP".equals(transport)) {
            return Transport.HTTP;
        }
        throw new IllegalArgumentException("Unknown transport " + transport);
    }

    public String toString() {
        return "Downstream(serviceName=" + this.getServiceName() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", transport=" + this.getTransport() + ", serverRole=" + this.getServerRole() + ", downstream=" + this.getDownstream() + ")";
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    public String getServerRole() {
        return this.serverRole;
    }

    public Downstream getDownstream() {
        return this.downstream;
    }
}

