/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.crossdock.resources.behavior;

import io.jaegertracing.crossdock.api.CreateTracesRequest;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.metrics.Metrics;
import io.jaegertracing.internal.metrics.NoopMetricsFactory;
import io.jaegertracing.internal.reporters.RemoteReporter;
import io.jaegertracing.internal.samplers.ConstSampler;
import io.jaegertracing.internal.samplers.HttpSamplingManager;
import io.jaegertracing.internal.samplers.ProbabilisticSampler;
import io.jaegertracing.internal.samplers.RemoteControlledSampler;
import io.jaegertracing.spi.MetricsFactory;
import io.jaegertracing.spi.Reporter;
import io.jaegertracing.spi.Sampler;
import io.jaegertracing.spi.SamplingManager;
import io.jaegertracing.spi.Sender;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.HashMap;
import java.util.Map;

public class EndToEndBehavior {
    private final Map<String, Tracer> tracers;

    public EndToEndBehavior(Map<String, Tracer> tracers) {
        this.tracers = new HashMap<String, Tracer>(tracers);
    }

    public EndToEndBehavior(String samplingHostPort, String serviceName, Sender sender) {
        Metrics metrics = new Metrics((MetricsFactory)new NoopMetricsFactory());
        RemoteReporter reporter = new RemoteReporter.Builder().withSender(sender).withFlushInterval(1000).withMaxQueueSize(100).withMetrics(metrics).build();
        ConstSampler constSampler = new ConstSampler(true);
        this.tracers = new HashMap<String, Tracer>();
        this.tracers.put("remote", this.getRemoteTracer(metrics, (Reporter)reporter, serviceName, samplingHostPort));
        this.tracers.put("const", (Tracer)new JaegerTracer.Builder(serviceName).withReporter((Reporter)reporter).withSampler((Sampler)constSampler).build());
    }

    private Tracer getRemoteTracer(Metrics metrics, Reporter reporter, String serviceName, String samplingHostPort) {
        ProbabilisticSampler initialSampler = new ProbabilisticSampler(1.0);
        HttpSamplingManager manager = new HttpSamplingManager(samplingHostPort);
        RemoteControlledSampler remoteSampler = new RemoteControlledSampler.Builder(serviceName).withSamplingManager((SamplingManager)manager).withInitialSampler((Sampler)initialSampler).withMetrics(metrics).withPollingInterval(5000).build();
        return new JaegerTracer.Builder(serviceName).withReporter(reporter).withSampler((Sampler)remoteSampler).build();
    }

    public void generateTraces(CreateTracesRequest request) {
        String samplerType = request.getType();
        Tracer tracer = this.tracers.get(samplerType);
        for (int i = 0; i < request.getCount(); ++i) {
            Tracer.SpanBuilder builder = tracer.buildSpan(request.getOperation());
            if (request.getTags() != null) {
                for (Map.Entry<String, String> kv : request.getTags().entrySet()) {
                    builder.withTag(kv.getKey(), kv.getValue());
                }
            }
            Span span = builder.start();
            span.finish();
        }
    }
}

