/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.crossdock.resources.behavior;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jaegertracing.crossdock.JerseyServer;
import io.jaegertracing.crossdock.api.Downstream;
import io.jaegertracing.crossdock.api.JoinTraceRequest;
import io.jaegertracing.crossdock.api.ObservedSpan;
import io.jaegertracing.crossdock.api.TraceResponse;
import io.jaegertracing.internal.JaegerSpan;
import io.jaegertracing.internal.JaegerSpanContext;
import io.opentracing.Tracer;
import java.io.IOException;
import java.net.InetAddress;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceBehavior {
    private static final Logger log = LoggerFactory.getLogger(TraceBehavior.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Tracer tracer;

    public TraceBehavior(Tracer tracer) {
        this.tracer = tracer;
    }

    public TraceResponse prepareResponse(Downstream downstream) throws Exception {
        TraceResponse response = new TraceResponse(this.observeSpan());
        if (downstream != null) {
            TraceResponse downstreamResponse = this.callDownstream(downstream);
            response.setDownstream(downstreamResponse);
        }
        return response;
    }

    private TraceResponse callDownstream(Downstream downstream) throws Exception {
        String transport;
        log.info("Calling downstream {}", (Object)downstream);
        log.info("Downstream service {} -> {}:{}", new Object[]{downstream.getServiceName(), InetAddress.getByName(downstream.getHost()), downstream.getPort()});
        switch (transport = downstream.getTransport()) {
            case "HTTP": {
                return this.callDownstreamHttp(downstream);
            }
        }
        return new TraceResponse("Unrecognized transport received: %s" + transport);
    }

    private TraceResponse callDownstreamHttp(Downstream downstream) throws IOException {
        String downstreamUrl = String.format("http://%s:%s/join_trace", downstream.getHost(), downstream.getPort());
        log.info("Calling downstream http {} at {}", (Object)downstream.getServiceName(), (Object)downstreamUrl);
        Response resp = JerseyServer.client.target(downstreamUrl).request(new String[]{"application/json"}).post(Entity.json((Object)new JoinTraceRequest(downstream.getServerRole(), downstream.getDownstream())));
        String respStr = (String)resp.readEntity(String.class);
        TraceResponse response = (TraceResponse)mapper.readValue(respStr, TraceResponse.class);
        log.info("Received response {}", (Object)response);
        return response;
    }

    private ObservedSpan observeSpan() {
        JaegerSpan span = (JaegerSpan)this.tracer.activeSpan();
        if (this.tracer.activeSpan() == null) {
            log.error("No span found");
            return new ObservedSpan("no span found", false, "no span found");
        }
        JaegerSpanContext context = span.context();
        String traceId = context.getTraceId();
        boolean sampled = context.isSampled();
        String baggage = span.getBaggageItem("crossdock-baggage-key");
        return new ObservedSpan(traceId, sampled, baggage);
    }
}

