/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.testcontainers;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.jaegertracing.api_v2.QueryServiceGrpc;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.reporters.RemoteReporter;
import io.jaegertracing.internal.samplers.ConstSampler;
import io.jaegertracing.spi.Reporter;
import io.jaegertracing.spi.Sampler;
import io.jaegertracing.spi.Sender;
import io.jaegertracing.thrift.internal.senders.HttpSender;
import java.util.Collections;
import java.util.Set;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class JaegerAllInOne
extends GenericContainer<JaegerAllInOne> {
    public static final int JAEGER_QUERY_PORT = 16686;
    public static final int JAEGER_COLLECTOR_THRIFT_PORT = 14268;
    public static final int JAEGER_COLLECTOR_GRPC_PORT = 14250;
    public static final int JAEGER_ADMIN_PORT = 14269;
    public static final int ZIPKIN_PORT = 9411;

    public JaegerAllInOne(String dockerImageName) {
        super(dockerImageName);
        this.init();
    }

    protected void init() {
        this.waitingFor((WaitStrategy)new BoundPortHttpWaitStrategy(14269));
        this.withEnv("COLLECTOR_ZIPKIN_HTTP_PORT", String.valueOf(9411));
        this.withExposedPorts(new Integer[]{14269, 14268, 14250, 16686, 9411});
    }

    public int getCollectorThriftPort() {
        return this.getMappedPort(14268);
    }

    public int getQueryPort() {
        return this.getMappedPort(16686);
    }

    public JaegerTracer createTracer(String serviceName) {
        String endpoint = String.format("http://localhost:%d/api/traces", this.getCollectorThriftPort());
        HttpSender sender = new HttpSender.Builder(endpoint).build();
        RemoteReporter reporter = new RemoteReporter.Builder().withSender((Sender)sender).build();
        JaegerTracer.Builder tracerBuilder = new JaegerTracer.Builder(serviceName).withSampler((Sampler)new ConstSampler(true)).withReporter((Reporter)reporter);
        return tracerBuilder.build();
    }

    public QueryServiceGrpc.QueryServiceBlockingStub createBlockingQueryService() {
        ManagedChannel channel = ManagedChannelBuilder.forTarget((String)String.format("localhost:%d", this.getQueryPort())).usePlaintext().build();
        return QueryServiceGrpc.newBlockingStub((Channel)channel);
    }

    public static class BoundPortHttpWaitStrategy
    extends HttpWaitStrategy {
        private final int port;

        public BoundPortHttpWaitStrategy(int port) {
            this.port = port;
        }

        protected Set<Integer> getLivenessCheckPorts() {
            int mapptedPort = this.waitStrategyTarget.getMappedPort(this.port);
            return Collections.singleton(mapptedPort);
        }
    }
}

