/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.testcontainers;

import io.jaegertracing.api_v2.Model;
import io.jaegertracing.api_v2.Query;
import io.jaegertracing.api_v2.QueryServiceGrpc;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;

public class WaitUtils {
    private WaitUtils() {
    }

    public static void untilQueryHasTag(QueryServiceGrpc.QueryServiceBlockingStub queryService, String service, String tagKey, String tagValue) {
        Query.TraceQueryParameters queryParameters = Query.TraceQueryParameters.newBuilder().setServiceName(service).build();
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> {
            Iterator traces = queryService.findTraces(Query.FindTracesRequest.newBuilder().setQuery(queryParameters).build());
            while (traces.hasNext()) {
                Query.SpansResponseChunk trace = (Query.SpansResponseChunk)traces.next();
                for (Model.Span span : trace.getSpansList()) {
                    for (Model.KeyValue tag : span.getTagsList()) {
                        if (!tagKey.equals(tag.getKey()) || !tagValue.equals(tag.getVStr())) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }
}

