/*
 * Decompiled with CFR 0.152.
 */
package jaeger.org.apache.http.client.protocol;

import jaeger.org.apache.http.HttpException;
import jaeger.org.apache.http.HttpRequest;
import jaeger.org.apache.http.HttpRequestInterceptor;
import jaeger.org.apache.http.annotation.Immutable;
import jaeger.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.List;

@Immutable
public class RequestAcceptEncoding
implements HttpRequestInterceptor {
    private final String acceptEncoding;

    public RequestAcceptEncoding(List<String> encodings) {
        if (encodings != null && !encodings.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < encodings.size(); ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(encodings.get(i));
            }
            this.acceptEncoding = buf.toString();
        } else {
            this.acceptEncoding = "gzip,deflate";
        }
    }

    public RequestAcceptEncoding() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (!request.containsHeader("Accept-Encoding")) {
            request.addHeader("Accept-Encoding", this.acceptEncoding);
        }
    }
}

