/*
 * Decompiled with CFR 0.152.
 */
package jaeger.org.apache.http.impl.client;

import jaeger.org.apache.http.HttpException;
import jaeger.org.apache.http.HttpHost;
import jaeger.org.apache.http.HttpRequest;
import jaeger.org.apache.http.annotation.ThreadSafe;
import jaeger.org.apache.http.client.ClientProtocolException;
import jaeger.org.apache.http.client.config.RequestConfig;
import jaeger.org.apache.http.client.methods.CloseableHttpResponse;
import jaeger.org.apache.http.client.methods.Configurable;
import jaeger.org.apache.http.client.methods.HttpExecutionAware;
import jaeger.org.apache.http.client.methods.HttpRequestWrapper;
import jaeger.org.apache.http.client.protocol.HttpClientContext;
import jaeger.org.apache.http.conn.ClientConnectionManager;
import jaeger.org.apache.http.conn.ClientConnectionRequest;
import jaeger.org.apache.http.conn.HttpClientConnectionManager;
import jaeger.org.apache.http.conn.ManagedClientConnection;
import jaeger.org.apache.http.conn.routing.HttpRoute;
import jaeger.org.apache.http.conn.scheme.SchemeRegistry;
import jaeger.org.apache.http.impl.DefaultConnectionReuseStrategy;
import jaeger.org.apache.http.impl.client.CloseableHttpClient;
import jaeger.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import jaeger.org.apache.http.impl.execchain.MinimalClientExec;
import jaeger.org.apache.http.params.BasicHttpParams;
import jaeger.org.apache.http.params.HttpParams;
import jaeger.org.apache.http.protocol.BasicHttpContext;
import jaeger.org.apache.http.protocol.HttpContext;
import jaeger.org.apache.http.protocol.HttpRequestExecutor;
import jaeger.org.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

