/*
 * Decompiled with CFR 0.152.
 */
package jaeger.org.apache.http.impl.cookie;

import jaeger.org.apache.http.annotation.Immutable;
import jaeger.org.apache.http.client.utils.DateUtils;
import jaeger.org.apache.http.cookie.CommonCookieAttributeHandler;
import jaeger.org.apache.http.cookie.MalformedCookieException;
import jaeger.org.apache.http.cookie.SetCookie;
import jaeger.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import jaeger.org.apache.http.util.Args;
import java.util.Date;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "expires";
    }
}

