/*
 * Decompiled with CFR 0.152.
 */
package jaeger.org.apache.http.protocol;

import jaeger.org.apache.http.HttpException;
import jaeger.org.apache.http.HttpRequest;
import jaeger.org.apache.http.HttpRequestInterceptor;
import jaeger.org.apache.http.annotation.Immutable;
import jaeger.org.apache.http.params.HttpParams;
import jaeger.org.apache.http.protocol.HttpContext;
import jaeger.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

