/*
 * Decompiled with CFR 0.152.
 */
package jaeger.org.apache.thrift;

import jaeger.org.apache.thrift.TException;
import jaeger.org.apache.thrift.TProcessor;
import jaeger.org.apache.thrift.protocol.TMessage;
import jaeger.org.apache.thrift.protocol.TProtocol;
import jaeger.org.apache.thrift.protocol.TProtocolDecorator;
import java.util.HashMap;
import java.util.Map;

public class TMultiplexedProcessor
implements TProcessor {
    private final Map<String, TProcessor> SERVICE_PROCESSOR_MAP = new HashMap<String, TProcessor>();
    private TProcessor defaultProcessor;

    public void registerProcessor(String serviceName, TProcessor processor) {
        this.SERVICE_PROCESSOR_MAP.put(serviceName, processor);
    }

    public void registerDefault(TProcessor processor) {
        this.defaultProcessor = processor;
    }

    public boolean process(TProtocol iprot, TProtocol oprot) throws TException {
        TMessage message = iprot.readMessageBegin();
        if (message.type != 1 && message.type != 4) {
            throw new TException("This should not have happened!?");
        }
        int index = message.name.indexOf(":");
        if (index < 0) {
            if (this.defaultProcessor != null) {
                return this.defaultProcessor.process(new StoredMessageProtocol(iprot, message), oprot);
            }
            throw new TException("Service name not found in message name: " + message.name + ".  Did you forget to use a TMultiplexProtocol in your client?");
        }
        String serviceName = message.name.substring(0, index);
        TProcessor actualProcessor = this.SERVICE_PROCESSOR_MAP.get(serviceName);
        if (actualProcessor == null) {
            throw new TException("Service name not found: " + serviceName + ".  Did you forget to call registerProcessor()?");
        }
        TMessage standardMessage = new TMessage(message.name.substring(serviceName.length() + ":".length()), message.type, message.seqid);
        return actualProcessor.process(new StoredMessageProtocol(iprot, standardMessage), oprot);
    }

    private static class StoredMessageProtocol
    extends TProtocolDecorator {
        TMessage messageBegin;

        public StoredMessageProtocol(TProtocol protocol, TMessage messageBegin) {
            super(protocol);
            this.messageBegin = messageBegin;
        }

        public TMessage readMessageBegin() throws TException {
            return this.messageBegin;
        }
    }
}

