/*
 * Decompiled with CFR 0.152.
 */
package jaeger.org.apache.thrift.transport;

import jaeger.org.apache.thrift.transport.TTransport;
import jaeger.org.apache.thrift.transport.TTransportException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;

public final class TByteBuffer
extends TTransport {
    private final ByteBuffer byteBuffer;

    public TByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public boolean isOpen() {
        return true;
    }

    public void open() {
    }

    public void close() {
    }

    public int read(byte[] buf, int off, int len) throws TTransportException {
        int n = Math.min(this.byteBuffer.remaining(), len);
        if (n > 0) {
            try {
                this.byteBuffer.get(buf, off, n);
            }
            catch (BufferUnderflowException e) {
                throw new TTransportException("Unexpected end of input buffer", (Throwable)e);
            }
        }
        return n;
    }

    public void write(byte[] buf, int off, int len) throws TTransportException {
        try {
            this.byteBuffer.put(buf, off, len);
        }
        catch (BufferOverflowException e) {
            throw new TTransportException("Not enough room in output buffer", (Throwable)e);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public TByteBuffer clear() {
        this.byteBuffer.clear();
        return this;
    }

    public TByteBuffer flip() {
        this.byteBuffer.flip();
        return this;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.byteBuffer.remaining()];
        this.byteBuffer.slice().get(data);
        return data;
    }
}

