/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.analytics;

import io.jaegertracing.analytics.ModelRunner;
import io.jaegertracing.analytics.gremlin.TraceTraversal;
import io.jaegertracing.analytics.gremlin.TraceTraversalSource;
import io.jaegertracing.analytics.gremlin.Util;
import io.opentracing.tag.Tags;
import io.prometheus.client.Histogram;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class NetworkLatency
implements ModelRunner {
    private static final Histogram histogram = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name("network_latency_seconds")).help("Network latency between client and server span")).labelNames(new String[]{"client", "server"})).create().register();

    @Override
    public void runWithMetrics(Graph graph) {
        Map<Name, Set<Double>> latencies = NetworkLatency.calculate(graph);
        for (Map.Entry<Name, Set<Double>> entry : latencies.entrySet()) {
            Histogram.Child child = (Histogram.Child)histogram.labels(new String[]{entry.getKey().client, entry.getKey().server});
            for (Double latency : entry.getValue()) {
                child.observe(latency.doubleValue());
            }
        }
    }

    public static Map<Name, Set<Double>> calculate(Graph graph) {
        LinkedHashMap<Name, Set<Double>> results = new LinkedHashMap<Name, Set<Double>>();
        TraceTraversal<Vertex, Vertex> clientSpans = ((TraceTraversalSource)graph.traversal(TraceTraversalSource.class)).hasTag(Tags.SPAN_KIND.getKey(), "client");
        clientSpans.forEachRemaining(client -> {
            String clientService = (String)client.property("serviceName").value();
            for (Vertex child : Util.children(client)) {
                if (!child.property(Tags.SPAN_KIND.getKey(), (Object)"server").isPresent()) continue;
                String serverService = (String)child.property("serviceName").value();
                Long clientStartTime = (Long)client.property("startTime").value();
                Long serverStartTime = (Long)child.property("startTime").value();
                Long latency = serverStartTime - clientStartTime;
                Name name = new Name(clientService, serverService);
                LinkedHashSet<Double> latencies = (LinkedHashSet<Double>)results.get(name);
                if (latencies == null) {
                    latencies = new LinkedHashSet<Double>();
                    results.put(name, latencies);
                }
                latencies.add((double)latency.longValue() / 1000000.0);
            }
        });
        return results;
    }

    public static class Name {
        public final String client;
        public final String server;

        public Name(String client, String server) {
            this.client = client;
            this.server = server;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Name name = (Name)o;
            return this.client.equals(name.client) && this.server.equals(name.server);
        }

        public int hashCode() {
            return Objects.hash(this.client, this.server);
        }

        public String toString() {
            return "Name{client='" + this.client + '\'' + ", server='" + this.server + '\'' + '}';
        }
    }
}

